<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InlineContent StructType
 * @subpackage Structs
 */
class InlineContent extends ContentType
{
    /**
     * The Binary
     * @var string
     */
    public $Binary;
    /**
     * Constructor method for InlineContent
     * @uses InlineContent::setBinary()
     * @param string $binary
     */
    public function __construct($binary = null)
    {
        $this
            ->setBinary($binary);
    }
    /**
     * Get Binary value
     * @return string|null
     */
    public function getBinary()
    {
        return $this->Binary;
    }
    /**
     * Set Binary value
     * @param string $binary
     * @return \StructType\InlineContent
     */
    public function setBinary($binary = null)
    {
        // validation for constraint: string
        if (!is_null($binary) && !is_string($binary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binary, true), gettype($binary)), __LINE__);
        }
        $this->Binary = $binary;
        return $this;
    }
}
