<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSearchMetadataRequest StructType
 * @subpackage Structs
 */
class GetSearchMetadataRequest extends AbstractStructBase
{
    /**
     * The SearchScope
     * @var \StructType\SearchScopeType
     */
    public $SearchScope;
    /**
     * The ClassFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassFilter;
    /**
     * The PropertyFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PropertyFilterType
     */
    public $PropertyFilter;
    /**
     * Constructor method for GetSearchMetadataRequest
     * @uses GetSearchMetadataRequest::setSearchScope()
     * @uses GetSearchMetadataRequest::setClassFilter()
     * @uses GetSearchMetadataRequest::setPropertyFilter()
     * @param \StructType\SearchScopeType $searchScope
     * @param string $classFilter
     * @param \StructType\PropertyFilterType $propertyFilter
     */
    public function __construct(\StructType\SearchScopeType $searchScope = null, $classFilter = null, \StructType\PropertyFilterType $propertyFilter = null)
    {
        $this
            ->setSearchScope($searchScope)
            ->setClassFilter($classFilter)
            ->setPropertyFilter($propertyFilter);
    }
    /**
     * Get SearchScope value
     * @return \StructType\SearchScopeType|null
     */
    public function getSearchScope()
    {
        return $this->SearchScope;
    }
    /**
     * Set SearchScope value
     * @param \StructType\SearchScopeType $searchScope
     * @return \StructType\GetSearchMetadataRequest
     */
    public function setSearchScope(\StructType\SearchScopeType $searchScope = null)
    {
        $this->SearchScope = $searchScope;
        return $this;
    }
    /**
     * Get ClassFilter value
     * @return string|null
     */
    public function getClassFilter()
    {
        return $this->ClassFilter;
    }
    /**
     * Set ClassFilter value
     * @param string $classFilter
     * @return \StructType\GetSearchMetadataRequest
     */
    public function setClassFilter($classFilter = null)
    {
        // validation for constraint: string
        if (!is_null($classFilter) && !is_string($classFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classFilter, true), gettype($classFilter)), __LINE__);
        }
        $this->ClassFilter = $classFilter;
        return $this;
    }
    /**
     * Get PropertyFilter value
     * @return \StructType\PropertyFilterType|null
     */
    public function getPropertyFilter()
    {
        return $this->PropertyFilter;
    }
    /**
     * Set PropertyFilter value
     * @param \StructType\PropertyFilterType $propertyFilter
     * @return \StructType\GetSearchMetadataRequest
     */
    public function setPropertyFilter(\StructType\PropertyFilterType $propertyFilter = null)
    {
        $this->PropertyFilter = $propertyFilter;
        return $this;
    }
}
