<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetObjectsResponse StructType
 * @subpackage Structs
 */
class GetObjectsResponse extends AbstractStructBase
{
    /**
     * The ObjectResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ObjectResponseType[]
     */
    public $ObjectResponse;
    /**
     * Constructor method for GetObjectsResponse
     * @uses GetObjectsResponse::setObjectResponse()
     * @param \StructType\ObjectResponseType[] $objectResponse
     */
    public function __construct(array $objectResponse = array())
    {
        $this
            ->setObjectResponse($objectResponse);
    }
    /**
     * Get ObjectResponse value
     * @return \StructType\ObjectResponseType[]|null
     */
    public function getObjectResponse()
    {
        return $this->ObjectResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setObjectResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjectResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectResponseForArrayConstraintsFromSetObjectResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getObjectsResponseObjectResponseItem) {
            // validation for constraint: itemType
            if (!$getObjectsResponseObjectResponseItem instanceof \StructType\ObjectResponseType) {
                $invalidValues[] = is_object($getObjectsResponseObjectResponseItem) ? get_class($getObjectsResponseObjectResponseItem) : sprintf('%s(%s)', gettype($getObjectsResponseObjectResponseItem), var_export($getObjectsResponseObjectResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ObjectResponse property can only contain items of type \StructType\ObjectResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ObjectResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectResponseType[] $objectResponse
     * @return \StructType\GetObjectsResponse
     */
    public function setObjectResponse(array $objectResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($objectResponseArrayErrorMessage = self::validateObjectResponseForArrayConstraintsFromSetObjectResponse($objectResponse))) {
            throw new \InvalidArgumentException($objectResponseArrayErrorMessage, __LINE__);
        }
        $this->ObjectResponse = $objectResponse;
        return $this;
    }
    /**
     * Add item to ObjectResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectResponseType $item
     * @return \StructType\GetObjectsResponse
     */
    public function addToObjectResponse(\StructType\ObjectResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ObjectResponseType) {
            throw new \InvalidArgumentException(sprintf('The ObjectResponse property can only contain items of type \StructType\ObjectResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ObjectResponse[] = $item;
        return $this;
    }
}
