<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetObjectsRequest StructType
 * @subpackage Structs
 */
class GetObjectsRequest extends AbstractStructBase
{
    /**
     * The ObjectRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ObjectRequestType[]
     */
    public $ObjectRequest;
    /**
     * Constructor method for GetObjectsRequest
     * @uses GetObjectsRequest::setObjectRequest()
     * @param \StructType\ObjectRequestType[] $objectRequest
     */
    public function __construct(array $objectRequest = array())
    {
        $this
            ->setObjectRequest($objectRequest);
    }
    /**
     * Get ObjectRequest value
     * @return \StructType\ObjectRequestType[]|null
     */
    public function getObjectRequest()
    {
        return $this->ObjectRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setObjectRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjectRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectRequestForArrayConstraintsFromSetObjectRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getObjectsRequestObjectRequestItem) {
            // validation for constraint: itemType
            if (!$getObjectsRequestObjectRequestItem instanceof \StructType\ObjectRequestType) {
                $invalidValues[] = is_object($getObjectsRequestObjectRequestItem) ? get_class($getObjectsRequestObjectRequestItem) : sprintf('%s(%s)', gettype($getObjectsRequestObjectRequestItem), var_export($getObjectsRequestObjectRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ObjectRequest property can only contain items of type \StructType\ObjectRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ObjectRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectRequestType[] $objectRequest
     * @return \StructType\GetObjectsRequest
     */
    public function setObjectRequest(array $objectRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($objectRequestArrayErrorMessage = self::validateObjectRequestForArrayConstraintsFromSetObjectRequest($objectRequest))) {
            throw new \InvalidArgumentException($objectRequestArrayErrorMessage, __LINE__);
        }
        $this->ObjectRequest = $objectRequest;
        return $this;
    }
    /**
     * Add item to ObjectRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectRequestType $item
     * @return \StructType\GetObjectsRequest
     */
    public function addToObjectRequest(\StructType\ObjectRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ObjectRequestType) {
            throw new \InvalidArgumentException(sprintf('The ObjectRequest property can only contain items of type \StructType\ObjectRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ObjectRequest[] = $item;
        return $this;
    }
}
