<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContentRequest StructType
 * @subpackage Structs
 */
class GetContentRequest extends AbstractStructBase
{
    /**
     * The ContentRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContentRequestType[]
     */
    public $ContentRequest;
    /**
     * The validateOnly
     * @var bool
     */
    public $validateOnly;
    /**
     * Constructor method for GetContentRequest
     * @uses GetContentRequest::setContentRequest()
     * @uses GetContentRequest::setValidateOnly()
     * @param \StructType\ContentRequestType[] $contentRequest
     * @param bool $validateOnly
     */
    public function __construct(array $contentRequest = array(), $validateOnly = null)
    {
        $this
            ->setContentRequest($contentRequest)
            ->setValidateOnly($validateOnly);
    }
    /**
     * Get ContentRequest value
     * @return \StructType\ContentRequestType[]|null
     */
    public function getContentRequest()
    {
        return $this->ContentRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setContentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentRequestForArrayConstraintsFromSetContentRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getContentRequestContentRequestItem) {
            // validation for constraint: itemType
            if (!$getContentRequestContentRequestItem instanceof \StructType\ContentRequestType) {
                $invalidValues[] = is_object($getContentRequestContentRequestItem) ? get_class($getContentRequestContentRequestItem) : sprintf('%s(%s)', gettype($getContentRequestContentRequestItem), var_export($getContentRequestContentRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentRequest property can only contain items of type \StructType\ContentRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentRequestType[] $contentRequest
     * @return \StructType\GetContentRequest
     */
    public function setContentRequest(array $contentRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($contentRequestArrayErrorMessage = self::validateContentRequestForArrayConstraintsFromSetContentRequest($contentRequest))) {
            throw new \InvalidArgumentException($contentRequestArrayErrorMessage, __LINE__);
        }
        $this->ContentRequest = $contentRequest;
        return $this;
    }
    /**
     * Add item to ContentRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentRequestType $item
     * @return \StructType\GetContentRequest
     */
    public function addToContentRequest(\StructType\ContentRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContentRequestType) {
            throw new \InvalidArgumentException(sprintf('The ContentRequest property can only contain items of type \StructType\ContentRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContentRequest[] = $item;
        return $this;
    }
    /**
     * Get validateOnly value
     * @return bool|null
     */
    public function getValidateOnly()
    {
        return $this->validateOnly;
    }
    /**
     * Set validateOnly value
     * @param bool $validateOnly
     * @return \StructType\GetContentRequest
     */
    public function setValidateOnly($validateOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($validateOnly) && !is_bool($validateOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validateOnly, true), gettype($validateOnly)), __LINE__);
        }
        $this->validateOnly = $validateOnly;
        return $this;
    }
}
