<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaultStackType StructType
 * @subpackage Structs
 */
class FaultStackType extends AbstractStructBase
{
    /**
     * The ErrorRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ErrorRecordType[]
     */
    public $ErrorRecord;
    /**
     * The ErrorName
     * @var string
     */
    public $ErrorName;
    /**
     * Constructor method for FaultStackType
     * @uses FaultStackType::setErrorRecord()
     * @uses FaultStackType::setErrorName()
     * @param \StructType\ErrorRecordType[] $errorRecord
     * @param string $errorName
     */
    public function __construct(array $errorRecord = array(), $errorName = null)
    {
        $this
            ->setErrorRecord($errorRecord)
            ->setErrorName($errorName);
    }
    /**
     * Get ErrorRecord value
     * @return \StructType\ErrorRecordType[]
     */
    public function getErrorRecord()
    {
        return $this->ErrorRecord;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorRecordForArrayConstraintsFromSetErrorRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $faultStackTypeErrorRecordItem) {
            // validation for constraint: itemType
            if (!$faultStackTypeErrorRecordItem instanceof \StructType\ErrorRecordType) {
                $invalidValues[] = is_object($faultStackTypeErrorRecordItem) ? get_class($faultStackTypeErrorRecordItem) : sprintf('%s(%s)', gettype($faultStackTypeErrorRecordItem), var_export($faultStackTypeErrorRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ErrorRecord property can only contain items of type \StructType\ErrorRecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ErrorRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorRecordType[] $errorRecord
     * @return \StructType\FaultStackType
     */
    public function setErrorRecord(array $errorRecord = array())
    {
        // validation for constraint: array
        if ('' !== ($errorRecordArrayErrorMessage = self::validateErrorRecordForArrayConstraintsFromSetErrorRecord($errorRecord))) {
            throw new \InvalidArgumentException($errorRecordArrayErrorMessage, __LINE__);
        }
        $this->ErrorRecord = $errorRecord;
        return $this;
    }
    /**
     * Add item to ErrorRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorRecordType $item
     * @return \StructType\FaultStackType
     */
    public function addToErrorRecord(\StructType\ErrorRecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorRecordType) {
            throw new \InvalidArgumentException(sprintf('The ErrorRecord property can only contain items of type \StructType\ErrorRecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ErrorRecord[] = $item;
        return $this;
    }
    /**
     * Get ErrorName value
     * @return string|null
     */
    public function getErrorName()
    {
        return $this->ErrorName;
    }
    /**
     * Set ErrorName value
     * @uses \EnumType\ErrorNameType::valueIsValid()
     * @uses \EnumType\ErrorNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorName
     * @return \StructType\FaultStackType
     */
    public function setErrorName($errorName = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ErrorNameType::valueIsValid($errorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ErrorNameType', is_array($errorName) ? implode(', ', $errorName) : var_export($errorName, true), implode(', ', \EnumType\ErrorNameType::getValidValues())), __LINE__);
        }
        $this->ErrorName = $errorName;
        return $this;
    }
}
