<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorRecordType StructType
 * @subpackage Structs
 */
class ErrorRecordType extends AbstractStructBase
{
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Diagnostic
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DiagnosticType[]
     */
    public $Diagnostic;
    /**
     * Constructor method for ErrorRecordType
     * @uses ErrorRecordType::setSource()
     * @uses ErrorRecordType::setDescription()
     * @uses ErrorRecordType::setDiagnostic()
     * @param string $source
     * @param string $description
     * @param \StructType\DiagnosticType[] $diagnostic
     */
    public function __construct($source = null, $description = null, array $diagnostic = array())
    {
        $this
            ->setSource($source)
            ->setDescription($description)
            ->setDiagnostic($diagnostic);
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\ErrorRecordType
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ErrorRecordType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Diagnostic value
     * @return \StructType\DiagnosticType[]|null
     */
    public function getDiagnostic()
    {
        return $this->Diagnostic;
    }
    /**
     * This method is responsible for validating the values passed to the setDiagnostic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiagnostic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiagnosticForArrayConstraintsFromSetDiagnostic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorRecordTypeDiagnosticItem) {
            // validation for constraint: itemType
            if (!$errorRecordTypeDiagnosticItem instanceof \StructType\DiagnosticType) {
                $invalidValues[] = is_object($errorRecordTypeDiagnosticItem) ? get_class($errorRecordTypeDiagnosticItem) : sprintf('%s(%s)', gettype($errorRecordTypeDiagnosticItem), var_export($errorRecordTypeDiagnosticItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Diagnostic property can only contain items of type \StructType\DiagnosticType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Diagnostic value
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticType[] $diagnostic
     * @return \StructType\ErrorRecordType
     */
    public function setDiagnostic(array $diagnostic = array())
    {
        // validation for constraint: array
        if ('' !== ($diagnosticArrayErrorMessage = self::validateDiagnosticForArrayConstraintsFromSetDiagnostic($diagnostic))) {
            throw new \InvalidArgumentException($diagnosticArrayErrorMessage, __LINE__);
        }
        $this->Diagnostic = $diagnostic;
        return $this;
    }
    /**
     * Add item to Diagnostic value
     * @throws \InvalidArgumentException
     * @param \StructType\DiagnosticType $item
     * @return \StructType\ErrorRecordType
     */
    public function addToDiagnostic(\StructType\DiagnosticType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiagnosticType) {
            throw new \InvalidArgumentException(sprintf('The Diagnostic property can only contain items of type \StructType\DiagnosticType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Diagnostic[] = $item;
        return $this;
    }
}
