<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementSpecificationType StructType
 * @subpackage Structs
 */
class ElementSpecificationType extends AbstractStructBase
{
    /**
     * The itemIndex
     * @var int
     */
    public $itemIndex;
    /**
     * The elementSequenceNumber
     * @var int
     */
    public $elementSequenceNumber;
    /**
     * Constructor method for ElementSpecificationType
     * @uses ElementSpecificationType::setItemIndex()
     * @uses ElementSpecificationType::setElementSequenceNumber()
     * @param int $itemIndex
     * @param int $elementSequenceNumber
     */
    public function __construct($itemIndex = null, $elementSequenceNumber = null)
    {
        $this
            ->setItemIndex($itemIndex)
            ->setElementSequenceNumber($elementSequenceNumber);
    }
    /**
     * Get itemIndex value
     * @return int|null
     */
    public function getItemIndex()
    {
        return $this->itemIndex;
    }
    /**
     * Set itemIndex value
     * @param int $itemIndex
     * @return \StructType\ElementSpecificationType
     */
    public function setItemIndex($itemIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itemIndex) && !(is_int($itemIndex) || ctype_digit($itemIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemIndex, true), gettype($itemIndex)), __LINE__);
        }
        $this->itemIndex = $itemIndex;
        return $this;
    }
    /**
     * Get elementSequenceNumber value
     * @return int|null
     */
    public function getElementSequenceNumber()
    {
        return $this->elementSequenceNumber;
    }
    /**
     * Set elementSequenceNumber value
     * @param int $elementSequenceNumber
     * @return \StructType\ElementSpecificationType
     */
    public function setElementSequenceNumber($elementSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($elementSequenceNumber) && !(is_int($elementSequenceNumber) || ctype_digit($elementSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elementSequenceNumber, true), gettype($elementSequenceNumber)), __LINE__);
        }
        $this->elementSequenceNumber = $elementSequenceNumber;
        return $this;
    }
}
