<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DependentObjectType StructType
 * @subpackage Structs
 */
class DependentObjectType extends ObjectValue
{
    /**
     * The originalIndex
     * @var int
     */
    public $originalIndex;
    /**
     * The newIndex
     * @var int
     */
    public $newIndex;
    /**
     * The dependentAction
     * @var string
     */
    public $dependentAction;
    /**
     * Constructor method for DependentObjectType
     * @uses DependentObjectType::setOriginalIndex()
     * @uses DependentObjectType::setNewIndex()
     * @uses DependentObjectType::setDependentAction()
     * @param int $originalIndex
     * @param int $newIndex
     * @param string $dependentAction
     */
    public function __construct($originalIndex = null, $newIndex = null, $dependentAction = null)
    {
        $this
            ->setOriginalIndex($originalIndex)
            ->setNewIndex($newIndex)
            ->setDependentAction($dependentAction);
    }
    /**
     * Get originalIndex value
     * @return int|null
     */
    public function getOriginalIndex()
    {
        return $this->originalIndex;
    }
    /**
     * Set originalIndex value
     * @param int $originalIndex
     * @return \StructType\DependentObjectType
     */
    public function setOriginalIndex($originalIndex = null)
    {
        // validation for constraint: int
        if (!is_null($originalIndex) && !(is_int($originalIndex) || ctype_digit($originalIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalIndex, true), gettype($originalIndex)), __LINE__);
        }
        $this->originalIndex = $originalIndex;
        return $this;
    }
    /**
     * Get newIndex value
     * @return int|null
     */
    public function getNewIndex()
    {
        return $this->newIndex;
    }
    /**
     * Set newIndex value
     * @param int $newIndex
     * @return \StructType\DependentObjectType
     */
    public function setNewIndex($newIndex = null)
    {
        // validation for constraint: int
        if (!is_null($newIndex) && !(is_int($newIndex) || ctype_digit($newIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newIndex, true), gettype($newIndex)), __LINE__);
        }
        $this->newIndex = $newIndex;
        return $this;
    }
    /**
     * Get dependentAction value
     * @return string|null
     */
    public function getDependentAction()
    {
        return $this->dependentAction;
    }
    /**
     * Set dependentAction value
     * @param string $dependentAction
     * @return \StructType\DependentObjectType
     */
    public function setDependentAction($dependentAction = null)
    {
        // validation for constraint: string
        if (!is_null($dependentAction) && !is_string($dependentAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependentAction, true), gettype($dependentAction)), __LINE__);
        }
        $this->dependentAction = $dependentAction;
        return $this;
    }
}
