<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckoutAction StructType
 * @subpackage Structs
 */
class CheckoutAction extends ActionType
{
    /**
     * The ReservationProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ModifiedPropertiesType
     */
    public $ReservationProperties;
    /**
     * The reservationId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}
     * @var string
     */
    public $reservationId;
    /**
     * The reservationType
     * @var string
     */
    public $reservationType;
    /**
     * The reservationClass
     * @var string
     */
    public $reservationClass;
    /**
     * Constructor method for CheckoutAction
     * @uses CheckoutAction::setReservationProperties()
     * @uses CheckoutAction::setReservationId()
     * @uses CheckoutAction::setReservationType()
     * @uses CheckoutAction::setReservationClass()
     * @param \StructType\ModifiedPropertiesType $reservationProperties
     * @param string $reservationId
     * @param string $reservationType
     * @param string $reservationClass
     */
    public function __construct(\StructType\ModifiedPropertiesType $reservationProperties = null, $reservationId = null, $reservationType = null, $reservationClass = null)
    {
        $this
            ->setReservationProperties($reservationProperties)
            ->setReservationId($reservationId)
            ->setReservationType($reservationType)
            ->setReservationClass($reservationClass);
    }
    /**
     * Get ReservationProperties value
     * @return \StructType\ModifiedPropertiesType|null
     */
    public function getReservationProperties()
    {
        return $this->ReservationProperties;
    }
    /**
     * Set ReservationProperties value
     * @param \StructType\ModifiedPropertiesType $reservationProperties
     * @return \StructType\CheckoutAction
     */
    public function setReservationProperties(\StructType\ModifiedPropertiesType $reservationProperties = null)
    {
        $this->ReservationProperties = $reservationProperties;
        return $this;
    }
    /**
     * Get reservationId value
     * @return string|null
     */
    public function getReservationId()
    {
        return $this->reservationId;
    }
    /**
     * Set reservationId value
     * @param string $reservationId
     * @return \StructType\CheckoutAction
     */
    public function setReservationId($reservationId = null)
    {
        // validation for constraint: string
        if (!is_null($reservationId) && !is_string($reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationId, true), gettype($reservationId)), __LINE__);
        }
        // validation for constraint: pattern(\{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\})
        if (!is_null($reservationId) && !preg_match('/\\{[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}\\}/', $reservationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{[0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}\}', var_export($reservationId, true)), __LINE__);
        }
        $this->reservationId = $reservationId;
        return $this;
    }
    /**
     * Get reservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->reservationType;
    }
    /**
     * Set reservationType value
     * @uses \EnumType\ReservationType::valueIsValid()
     * @uses \EnumType\ReservationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationType
     * @return \StructType\CheckoutAction
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReservationType::valueIsValid($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReservationType', is_array($reservationType) ? implode(', ', $reservationType) : var_export($reservationType, true), implode(', ', \EnumType\ReservationType::getValidValues())), __LINE__);
        }
        $this->reservationType = $reservationType;
        return $this;
    }
    /**
     * Get reservationClass value
     * @return string|null
     */
    public function getReservationClass()
    {
        return $this->reservationClass;
    }
    /**
     * Set reservationClass value
     * @param string $reservationClass
     * @return \StructType\CheckoutAction
     */
    public function setReservationClass($reservationClass = null)
    {
        // validation for constraint: string
        if (!is_null($reservationClass) && !is_string($reservationClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationClass, true), gettype($reservationClass)), __LINE__);
        }
        $this->reservationClass = $reservationClass;
        return $this;
    }
}
