<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckinAction StructType
 * @subpackage Structs
 */
class CheckinAction extends ActionType
{
    /**
     * The autoClassify
     * @var bool
     */
    public $autoClassify;
    /**
     * The checkinMinorVersion
     * @var bool
     */
    public $checkinMinorVersion;
    /**
     * Constructor method for CheckinAction
     * @uses CheckinAction::setAutoClassify()
     * @uses CheckinAction::setCheckinMinorVersion()
     * @param bool $autoClassify
     * @param bool $checkinMinorVersion
     */
    public function __construct($autoClassify = null, $checkinMinorVersion = null)
    {
        $this
            ->setAutoClassify($autoClassify)
            ->setCheckinMinorVersion($checkinMinorVersion);
    }
    /**
     * Get autoClassify value
     * @return bool|null
     */
    public function getAutoClassify()
    {
        return $this->autoClassify;
    }
    /**
     * Set autoClassify value
     * @param bool $autoClassify
     * @return \StructType\CheckinAction
     */
    public function setAutoClassify($autoClassify = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoClassify) && !is_bool($autoClassify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoClassify, true), gettype($autoClassify)), __LINE__);
        }
        $this->autoClassify = $autoClassify;
        return $this;
    }
    /**
     * Get checkinMinorVersion value
     * @return bool|null
     */
    public function getCheckinMinorVersion()
    {
        return $this->checkinMinorVersion;
    }
    /**
     * Set checkinMinorVersion value
     * @param bool $checkinMinorVersion
     * @return \StructType\CheckinAction
     */
    public function setCheckinMinorVersion($checkinMinorVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkinMinorVersion) && !is_bool($checkinMinorVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkinMinorVersion, true), gettype($checkinMinorVersion)), __LINE__);
        }
        $this->checkinMinorVersion = $checkinMinorVersion;
        return $this;
    }
}
