<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeClassAction StructType
 * @subpackage Structs
 */
class ChangeClassAction extends ActionType
{
    /**
     * The newClass
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $newClass;
    /**
     * Constructor method for ChangeClassAction
     * @uses ChangeClassAction::setNewClass()
     * @param string $newClass
     */
    public function __construct($newClass = null)
    {
        $this
            ->setNewClass($newClass);
    }
    /**
     * Get newClass value
     * @return string
     */
    public function getNewClass()
    {
        return $this->newClass;
    }
    /**
     * Set newClass value
     * @param string $newClass
     * @return \StructType\ChangeClassAction
     */
    public function setNewClass($newClass = null)
    {
        // validation for constraint: string
        if (!is_null($newClass) && !is_string($newClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newClass, true), gettype($newClass)), __LINE__);
        }
        $this->newClass = $newClass;
        return $this;
    }
}
