<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Sets the Localization SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Localization $localization
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocalization(\StructType\Localization $localization, $nameSpace = 'http://www.filenet.com/ns/fnce/2006/11/ws/schema', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Localization', $localization, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ExecuteChanges
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Localization
     * - SOAPHeaderNamespaces: http://www.filenet.com/ns/fnce/2006/11/ws/schema
     * - SOAPHeaderTypes: \StructType\Localization
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExecuteChangesRequest $request
     * @return \StructType\ExecuteChangesResponse|bool
     */
    public function ExecuteChanges(\StructType\ExecuteChangesRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteChanges($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExecuteSearch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Localization
     * - SOAPHeaderNamespaces: http://www.filenet.com/ns/fnce/2006/11/ws/schema
     * - SOAPHeaderTypes: \StructType\Localization
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchRequestType $request
     * @return \StructType\ObjectSetType|bool
     */
    public function ExecuteSearch(\StructType\SearchRequestType $request)
    {
        try {
            $this->setResult($this->getSoapClient()->ExecuteSearch($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExecuteChangesResponse|\StructType\ObjectSetType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
