<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ErrorNameType EnumType
 * @subpackage Enumerations
 */
class ErrorNameType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SERVER_ERROR'
     * @return string 'SERVER_ERROR'
     */
    const VALUE_SERVER_ERROR = 'SERVER_ERROR';
    /**
     * Constant for value 'HEAP_FAILURE'
     * @return string 'HEAP_FAILURE'
     */
    const VALUE_HEAP_FAILURE = 'HEAP_FAILURE';
    /**
     * Constant for value 'DEADLOCK_ERROR'
     * @return string 'DEADLOCK_ERROR'
     */
    const VALUE_DEADLOCK_ERROR = 'DEADLOCK_ERROR';
    /**
     * Constant for value 'DATABASE_ERROR'
     * @return string 'DATABASE_ERROR'
     */
    const VALUE_DATABASE_ERROR = 'DATABASE_ERROR';
    /**
     * Constant for value 'DATABASE_FULL'
     * @return string 'DATABASE_FULL'
     */
    const VALUE_DATABASE_FULL = 'DATABASE_FULL';
    /**
     * Constant for value 'TRANSACTION_TIMEOUT'
     * @return string 'TRANSACTION_TIMEOUT'
     */
    const VALUE_TRANSACTION_TIMEOUT = 'TRANSACTION_TIMEOUT';
    /**
     * Constant for value 'AUTHENTICATION_FAILURE'
     * @return string 'AUTHENTICATION_FAILURE'
     */
    const VALUE_AUTHENTICATION_FAILURE = 'AUTHENTICATION_FAILURE';
    /**
     * Constant for value 'NOT_SUPPORTED'
     * @return string 'NOT_SUPPORTED'
     */
    const VALUE_NOT_SUPPORTED = 'NOT_SUPPORTED';
    /**
     * Constant for value 'BAD_CLASSID'
     * @return string 'BAD_CLASSID'
     */
    const VALUE_BAD_CLASSID = 'BAD_CLASSID';
    /**
     * Constant for value 'BAD_PROPERTYID'
     * @return string 'BAD_PROPERTYID'
     */
    const VALUE_BAD_PROPERTYID = 'BAD_PROPERTYID';
    /**
     * Constant for value 'BAD_INDEX'
     * @return string 'BAD_INDEX'
     */
    const VALUE_BAD_INDEX = 'BAD_INDEX';
    /**
     * Constant for value 'BAD_OBJECT'
     * @return string 'BAD_OBJECT'
     */
    const VALUE_BAD_OBJECT = 'BAD_OBJECT';
    /**
     * Constant for value 'INVALID_REQUEST'
     * @return string 'INVALID_REQUEST'
     */
    const VALUE_INVALID_REQUEST = 'INVALID_REQUEST';
    /**
     * Constant for value 'REQUIRED_VALUE_ABSENT'
     * @return string 'REQUIRED_VALUE_ABSENT'
     */
    const VALUE_REQUIRED_VALUE_ABSENT = 'REQUIRED_VALUE_ABSENT';
    /**
     * Constant for value 'OBJECT_NOT_FOUND'
     * @return string 'OBJECT_NOT_FOUND'
     */
    const VALUE_OBJECT_NOT_FOUND = 'OBJECT_NOT_FOUND';
    /**
     * Constant for value 'OBJECT_DELETED'
     * @return string 'OBJECT_DELETED'
     */
    const VALUE_OBJECT_DELETED = 'OBJECT_DELETED';
    /**
     * Constant for value 'BAD_VALUE'
     * @return string 'BAD_VALUE'
     */
    const VALUE_BAD_VALUE = 'BAD_VALUE';
    /**
     * Constant for value 'DATATYPE_MISMATCH'
     * @return string 'DATATYPE_MISMATCH'
     */
    const VALUE_DATATYPE_MISMATCH = 'DATATYPE_MISMATCH';
    /**
     * Constant for value 'ACCESS_DENIED'
     * @return string 'ACCESS_DENIED'
     */
    const VALUE_ACCESS_DENIED = 'ACCESS_DENIED';
    /**
     * Constant for value 'CONSTRAINT_VIOLATED'
     * @return string 'CONSTRAINT_VIOLATED'
     */
    const VALUE_CONSTRAINT_VIOLATED = 'CONSTRAINT_VIOLATED';
    /**
     * Constant for value 'NOT_UNIQUE'
     * @return string 'NOT_UNIQUE'
     */
    const VALUE_NOT_UNIQUE = 'NOT_UNIQUE';
    /**
     * Constant for value 'OBJECT_MODIFIED'
     * @return string 'OBJECT_MODIFIED'
     */
    const VALUE_OBJECT_MODIFIED = 'OBJECT_MODIFIED';
    /**
     * Constant for value 'OBJECT_REFERENCED'
     * @return string 'OBJECT_REFERENCED'
     */
    const VALUE_OBJECT_REFERENCED = 'OBJECT_REFERENCED';
    /**
     * Constant for value 'OBJECT_REFERENCES_OTHERS'
     * @return string 'OBJECT_REFERENCES_OTHERS'
     */
    const VALUE_OBJECT_REFERENCES_OTHERS = 'OBJECT_REFERENCES_OTHERS';
    /**
     * Constant for value 'OBJECT_LOCKED'
     * @return string 'OBJECT_LOCKED'
     */
    const VALUE_OBJECT_LOCKED = 'OBJECT_LOCKED';
    /**
     * Constant for value 'OBJECT_NOT_LOCKED'
     * @return string 'OBJECT_NOT_LOCKED'
     */
    const VALUE_OBJECT_NOT_LOCKED = 'OBJECT_NOT_LOCKED';
    /**
     * Constant for value 'RESERVATION_EXISTS'
     * @return string 'RESERVATION_EXISTS'
     */
    const VALUE_RESERVATION_EXISTS = 'RESERVATION_EXISTS';
    /**
     * Return allowed values
     * @uses self::VALUE_SERVER_ERROR
     * @uses self::VALUE_HEAP_FAILURE
     * @uses self::VALUE_DEADLOCK_ERROR
     * @uses self::VALUE_DATABASE_ERROR
     * @uses self::VALUE_DATABASE_FULL
     * @uses self::VALUE_TRANSACTION_TIMEOUT
     * @uses self::VALUE_AUTHENTICATION_FAILURE
     * @uses self::VALUE_NOT_SUPPORTED
     * @uses self::VALUE_BAD_CLASSID
     * @uses self::VALUE_BAD_PROPERTYID
     * @uses self::VALUE_BAD_INDEX
     * @uses self::VALUE_BAD_OBJECT
     * @uses self::VALUE_INVALID_REQUEST
     * @uses self::VALUE_REQUIRED_VALUE_ABSENT
     * @uses self::VALUE_OBJECT_NOT_FOUND
     * @uses self::VALUE_OBJECT_DELETED
     * @uses self::VALUE_BAD_VALUE
     * @uses self::VALUE_DATATYPE_MISMATCH
     * @uses self::VALUE_ACCESS_DENIED
     * @uses self::VALUE_CONSTRAINT_VIOLATED
     * @uses self::VALUE_NOT_UNIQUE
     * @uses self::VALUE_OBJECT_MODIFIED
     * @uses self::VALUE_OBJECT_REFERENCED
     * @uses self::VALUE_OBJECT_REFERENCES_OTHERS
     * @uses self::VALUE_OBJECT_LOCKED
     * @uses self::VALUE_OBJECT_NOT_LOCKED
     * @uses self::VALUE_RESERVATION_EXISTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERVER_ERROR,
            self::VALUE_HEAP_FAILURE,
            self::VALUE_DEADLOCK_ERROR,
            self::VALUE_DATABASE_ERROR,
            self::VALUE_DATABASE_FULL,
            self::VALUE_TRANSACTION_TIMEOUT,
            self::VALUE_AUTHENTICATION_FAILURE,
            self::VALUE_NOT_SUPPORTED,
            self::VALUE_BAD_CLASSID,
            self::VALUE_BAD_PROPERTYID,
            self::VALUE_BAD_INDEX,
            self::VALUE_BAD_OBJECT,
            self::VALUE_INVALID_REQUEST,
            self::VALUE_REQUIRED_VALUE_ABSENT,
            self::VALUE_OBJECT_NOT_FOUND,
            self::VALUE_OBJECT_DELETED,
            self::VALUE_BAD_VALUE,
            self::VALUE_DATATYPE_MISMATCH,
            self::VALUE_ACCESS_DENIED,
            self::VALUE_CONSTRAINT_VIOLATED,
            self::VALUE_NOT_UNIQUE,
            self::VALUE_OBJECT_MODIFIED,
            self::VALUE_OBJECT_REFERENCED,
            self::VALUE_OBJECT_REFERENCES_OTHERS,
            self::VALUE_OBJECT_LOCKED,
            self::VALUE_OBJECT_NOT_LOCKED,
            self::VALUE_RESERVATION_EXISTS,
        );
    }
}
