<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectSetType StructType
 * @subpackage Structs
 */
class ObjectSetType extends AbstractStructBase
{
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ObjectValue[]
     */
    public $Object;
    /**
     * The CollectionTerminator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CollectionTerminatorType
     */
    public $CollectionTerminator;
    /**
     * Constructor method for ObjectSetType
     * @uses ObjectSetType::setObject()
     * @uses ObjectSetType::setCollectionTerminator()
     * @param \StructType\ObjectValue[] $object
     * @param \StructType\CollectionTerminatorType $collectionTerminator
     */
    public function __construct(array $object = array(), \StructType\CollectionTerminatorType $collectionTerminator = null)
    {
        $this
            ->setObject($object)
            ->setCollectionTerminator($collectionTerminator);
    }
    /**
     * Get Object value
     * @return \StructType\ObjectValue[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectSetTypeObjectItem) {
            // validation for constraint: itemType
            if (!$objectSetTypeObjectItem instanceof \StructType\ObjectValue) {
                $invalidValues[] = is_object($objectSetTypeObjectItem) ? get_class($objectSetTypeObjectItem) : sprintf('%s(%s)', gettype($objectSetTypeObjectItem), var_export($objectSetTypeObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Object property can only contain items of type \StructType\ObjectValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectValue[] $object
     * @return \StructType\ObjectSetType
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \StructType\ObjectValue $item
     * @return \StructType\ObjectSetType
     */
    public function addToObject(\StructType\ObjectValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ObjectValue) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of type \StructType\ObjectValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get CollectionTerminator value
     * @return \StructType\CollectionTerminatorType|null
     */
    public function getCollectionTerminator()
    {
        return $this->CollectionTerminator;
    }
    /**
     * Set CollectionTerminator value
     * @param \StructType\CollectionTerminatorType $collectionTerminator
     * @return \StructType\ObjectSetType
     */
    public function setCollectionTerminator(\StructType\CollectionTerminatorType $collectionTerminator = null)
    {
        $this->CollectionTerminator = $collectionTerminator;
        return $this;
    }
}
