<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetContentResponse StructType
 * @subpackage Structs
 */
class GetContentResponse extends AbstractStructBase
{
    /**
     * The ContentResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContentResponseType[]
     */
    public $ContentResponse;
    /**
     * Constructor method for GetContentResponse
     * @uses GetContentResponse::setContentResponse()
     * @param \StructType\ContentResponseType[] $contentResponse
     */
    public function __construct(array $contentResponse = array())
    {
        $this
            ->setContentResponse($contentResponse);
    }
    /**
     * Get ContentResponse value
     * @return \StructType\ContentResponseType[]|null
     */
    public function getContentResponse()
    {
        return $this->ContentResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setContentResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentResponseForArrayConstraintsFromSetContentResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getContentResponseContentResponseItem) {
            // validation for constraint: itemType
            if (!$getContentResponseContentResponseItem instanceof \StructType\ContentResponseType) {
                $invalidValues[] = is_object($getContentResponseContentResponseItem) ? get_class($getContentResponseContentResponseItem) : sprintf('%s(%s)', gettype($getContentResponseContentResponseItem), var_export($getContentResponseContentResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentResponse property can only contain items of type \StructType\ContentResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentResponseType[] $contentResponse
     * @return \StructType\GetContentResponse
     */
    public function setContentResponse(array $contentResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($contentResponseArrayErrorMessage = self::validateContentResponseForArrayConstraintsFromSetContentResponse($contentResponse))) {
            throw new \InvalidArgumentException($contentResponseArrayErrorMessage, __LINE__);
        }
        $this->ContentResponse = $contentResponse;
        return $this;
    }
    /**
     * Add item to ContentResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentResponseType $item
     * @return \StructType\GetContentResponse
     */
    public function addToContentResponse(\StructType\ContentResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContentResponseType) {
            throw new \InvalidArgumentException(sprintf('The ContentResponse property can only contain items of type \StructType\ContentResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContentResponse[] = $item;
        return $this;
    }
}
