<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilterElementType StructType
 * @subpackage Structs
 */
class FilterElementType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The maxRecursion
     * @var int
     */
    public $maxRecursion;
    /**
     * The maxSize
     * @var int
     */
    public $maxSize;
    /**
     * The maxElements
     * @var int
     */
    public $maxElements;
    /**
     * The levelDependents
     * @var bool
     */
    public $levelDependents;
    /**
     * Constructor method for FilterElementType
     * @uses FilterElementType::set_()
     * @uses FilterElementType::setMaxRecursion()
     * @uses FilterElementType::setMaxSize()
     * @uses FilterElementType::setMaxElements()
     * @uses FilterElementType::setLevelDependents()
     * @param string $_
     * @param int $maxRecursion
     * @param int $maxSize
     * @param int $maxElements
     * @param bool $levelDependents
     */
    public function __construct($_ = null, $maxRecursion = null, $maxSize = null, $maxElements = null, $levelDependents = null)
    {
        $this
            ->set_($_)
            ->setMaxRecursion($maxRecursion)
            ->setMaxSize($maxSize)
            ->setMaxElements($maxElements)
            ->setLevelDependents($levelDependents);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\FilterElementType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get maxRecursion value
     * @return int|null
     */
    public function getMaxRecursion()
    {
        return $this->maxRecursion;
    }
    /**
     * Set maxRecursion value
     * @param int $maxRecursion
     * @return \StructType\FilterElementType
     */
    public function setMaxRecursion($maxRecursion = null)
    {
        // validation for constraint: int
        if (!is_null($maxRecursion) && !(is_int($maxRecursion) || ctype_digit($maxRecursion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRecursion, true), gettype($maxRecursion)), __LINE__);
        }
        $this->maxRecursion = $maxRecursion;
        return $this;
    }
    /**
     * Get maxSize value
     * @return int|null
     */
    public function getMaxSize()
    {
        return $this->maxSize;
    }
    /**
     * Set maxSize value
     * @param int $maxSize
     * @return \StructType\FilterElementType
     */
    public function setMaxSize($maxSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxSize) && !(is_int($maxSize) || ctype_digit($maxSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSize, true), gettype($maxSize)), __LINE__);
        }
        $this->maxSize = $maxSize;
        return $this;
    }
    /**
     * Get maxElements value
     * @return int|null
     */
    public function getMaxElements()
    {
        return $this->maxElements;
    }
    /**
     * Set maxElements value
     * @param int $maxElements
     * @return \StructType\FilterElementType
     */
    public function setMaxElements($maxElements = null)
    {
        // validation for constraint: int
        if (!is_null($maxElements) && !(is_int($maxElements) || ctype_digit($maxElements))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxElements, true), gettype($maxElements)), __LINE__);
        }
        $this->maxElements = $maxElements;
        return $this;
    }
    /**
     * Get levelDependents value
     * @return bool|null
     */
    public function getLevelDependents()
    {
        return $this->levelDependents;
    }
    /**
     * Set levelDependents value
     * @param bool $levelDependents
     * @return \StructType\FilterElementType
     */
    public function setLevelDependents($levelDependents = null)
    {
        // validation for constraint: boolean
        if (!is_null($levelDependents) && !is_bool($levelDependents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($levelDependents, true), gettype($levelDependents)), __LINE__);
        }
        $this->levelDependents = $levelDependents;
        return $this;
    }
}
