<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentRequestType StructType
 * @subpackage Structs
 */
class ContentRequestType extends AbstractStructBase
{
    /**
     * The SourceSpecification
     * @var \StructType\ObjectReference
     */
    public $SourceSpecification;
    /**
     * The ElementSpecification
     * @var \StructType\ElementSpecificationType
     */
    public $ElementSpecification;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The cacheAllowed
     * @var bool
     */
    public $cacheAllowed;
    /**
     * The continueFrom
     * @var string
     */
    public $continueFrom;
    /**
     * The startOffset
     * @var int
     */
    public $startOffset;
    /**
     * The maxBytes
     * @var int
     */
    public $maxBytes;
    /**
     * Constructor method for ContentRequestType
     * @uses ContentRequestType::setSourceSpecification()
     * @uses ContentRequestType::setElementSpecification()
     * @uses ContentRequestType::setId()
     * @uses ContentRequestType::setCacheAllowed()
     * @uses ContentRequestType::setContinueFrom()
     * @uses ContentRequestType::setStartOffset()
     * @uses ContentRequestType::setMaxBytes()
     * @param \StructType\ObjectReference $sourceSpecification
     * @param \StructType\ElementSpecificationType $elementSpecification
     * @param string $id
     * @param bool $cacheAllowed
     * @param string $continueFrom
     * @param int $startOffset
     * @param int $maxBytes
     */
    public function __construct(\StructType\ObjectReference $sourceSpecification = null, \StructType\ElementSpecificationType $elementSpecification = null, $id = null, $cacheAllowed = null, $continueFrom = null, $startOffset = null, $maxBytes = null)
    {
        $this
            ->setSourceSpecification($sourceSpecification)
            ->setElementSpecification($elementSpecification)
            ->setId($id)
            ->setCacheAllowed($cacheAllowed)
            ->setContinueFrom($continueFrom)
            ->setStartOffset($startOffset)
            ->setMaxBytes($maxBytes);
    }
    /**
     * Get SourceSpecification value
     * @return \StructType\ObjectReference|null
     */
    public function getSourceSpecification()
    {
        return $this->SourceSpecification;
    }
    /**
     * Set SourceSpecification value
     * @param \StructType\ObjectReference $sourceSpecification
     * @return \StructType\ContentRequestType
     */
    public function setSourceSpecification(\StructType\ObjectReference $sourceSpecification = null)
    {
        $this->SourceSpecification = $sourceSpecification;
        return $this;
    }
    /**
     * Get ElementSpecification value
     * @return \StructType\ElementSpecificationType|null
     */
    public function getElementSpecification()
    {
        return $this->ElementSpecification;
    }
    /**
     * Set ElementSpecification value
     * @param \StructType\ElementSpecificationType $elementSpecification
     * @return \StructType\ContentRequestType
     */
    public function setElementSpecification(\StructType\ElementSpecificationType $elementSpecification = null)
    {
        $this->ElementSpecification = $elementSpecification;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ContentRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get cacheAllowed value
     * @return bool|null
     */
    public function getCacheAllowed()
    {
        return $this->cacheAllowed;
    }
    /**
     * Set cacheAllowed value
     * @param bool $cacheAllowed
     * @return \StructType\ContentRequestType
     */
    public function setCacheAllowed($cacheAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($cacheAllowed) && !is_bool($cacheAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cacheAllowed, true), gettype($cacheAllowed)), __LINE__);
        }
        $this->cacheAllowed = $cacheAllowed;
        return $this;
    }
    /**
     * Get continueFrom value
     * @return string|null
     */
    public function getContinueFrom()
    {
        return $this->continueFrom;
    }
    /**
     * Set continueFrom value
     * @param string $continueFrom
     * @return \StructType\ContentRequestType
     */
    public function setContinueFrom($continueFrom = null)
    {
        // validation for constraint: string
        if (!is_null($continueFrom) && !is_string($continueFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continueFrom, true), gettype($continueFrom)), __LINE__);
        }
        $this->continueFrom = $continueFrom;
        return $this;
    }
    /**
     * Get startOffset value
     * @return int|null
     */
    public function getStartOffset()
    {
        return $this->startOffset;
    }
    /**
     * Set startOffset value
     * @param int $startOffset
     * @return \StructType\ContentRequestType
     */
    public function setStartOffset($startOffset = null)
    {
        // validation for constraint: int
        if (!is_null($startOffset) && !(is_int($startOffset) || ctype_digit($startOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startOffset, true), gettype($startOffset)), __LINE__);
        }
        $this->startOffset = $startOffset;
        return $this;
    }
    /**
     * Get maxBytes value
     * @return int|null
     */
    public function getMaxBytes()
    {
        return $this->maxBytes;
    }
    /**
     * Set maxBytes value
     * @param int $maxBytes
     * @return \StructType\ContentRequestType
     */
    public function setMaxBytes($maxBytes = null)
    {
        // validation for constraint: int
        if (!is_null($maxBytes) && !(is_int($maxBytes) || ctype_digit($maxBytes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBytes, true), gettype($maxBytes)), __LINE__);
        }
        $this->maxBytes = $maxBytes;
        return $this;
    }
}
