<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeRequestType StructType
 * @subpackage Structs
 */
class ChangeRequestType extends AbstractStructBase
{
    /**
     * The TargetSpecification
     * @var \StructType\ObjectReference
     */
    public $TargetSpecification;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActionType[]
     */
    public $Action;
    /**
     * The ActionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ModifiedPropertiesType
     */
    public $ActionProperties;
    /**
     * The RefreshFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PropertyFilterType
     */
    public $RefreshFilter;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The updateSequenceNumber
     * @var int
     */
    public $updateSequenceNumber;
    /**
     * Constructor method for ChangeRequestType
     * @uses ChangeRequestType::setTargetSpecification()
     * @uses ChangeRequestType::setAction()
     * @uses ChangeRequestType::setActionProperties()
     * @uses ChangeRequestType::setRefreshFilter()
     * @uses ChangeRequestType::setId()
     * @uses ChangeRequestType::setUpdateSequenceNumber()
     * @param \StructType\ObjectReference $targetSpecification
     * @param \StructType\ActionType[] $action
     * @param \StructType\ModifiedPropertiesType $actionProperties
     * @param \StructType\PropertyFilterType $refreshFilter
     * @param string $id
     * @param int $updateSequenceNumber
     */
    public function __construct(\StructType\ObjectReference $targetSpecification = null, array $action = array(), \StructType\ModifiedPropertiesType $actionProperties = null, \StructType\PropertyFilterType $refreshFilter = null, $id = null, $updateSequenceNumber = null)
    {
        $this
            ->setTargetSpecification($targetSpecification)
            ->setAction($action)
            ->setActionProperties($actionProperties)
            ->setRefreshFilter($refreshFilter)
            ->setId($id)
            ->setUpdateSequenceNumber($updateSequenceNumber);
    }
    /**
     * Get TargetSpecification value
     * @return \StructType\ObjectReference|null
     */
    public function getTargetSpecification()
    {
        return $this->TargetSpecification;
    }
    /**
     * Set TargetSpecification value
     * @param \StructType\ObjectReference $targetSpecification
     * @return \StructType\ChangeRequestType
     */
    public function setTargetSpecification(\StructType\ObjectReference $targetSpecification = null)
    {
        $this->TargetSpecification = $targetSpecification;
        return $this;
    }
    /**
     * Get Action value
     * @return \StructType\ActionType[]|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * This method is responsible for validating the values passed to the setAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionForArrayConstraintsFromSetAction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $changeRequestTypeActionItem) {
            // validation for constraint: itemType
            if (!$changeRequestTypeActionItem instanceof \StructType\ActionType) {
                $invalidValues[] = is_object($changeRequestTypeActionItem) ? get_class($changeRequestTypeActionItem) : sprintf('%s(%s)', gettype($changeRequestTypeActionItem), var_export($changeRequestTypeActionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Action property can only contain items of type \StructType\ActionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Action value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionType[] $action
     * @return \StructType\ChangeRequestType
     */
    public function setAction(array $action = array())
    {
        // validation for constraint: array
        if ('' !== ($actionArrayErrorMessage = self::validateActionForArrayConstraintsFromSetAction($action))) {
            throw new \InvalidArgumentException($actionArrayErrorMessage, __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Add item to Action value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionType $item
     * @return \StructType\ChangeRequestType
     */
    public function addToAction(\StructType\ActionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActionType) {
            throw new \InvalidArgumentException(sprintf('The Action property can only contain items of type \StructType\ActionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Action[] = $item;
        return $this;
    }
    /**
     * Get ActionProperties value
     * @return \StructType\ModifiedPropertiesType|null
     */
    public function getActionProperties()
    {
        return $this->ActionProperties;
    }
    /**
     * Set ActionProperties value
     * @param \StructType\ModifiedPropertiesType $actionProperties
     * @return \StructType\ChangeRequestType
     */
    public function setActionProperties(\StructType\ModifiedPropertiesType $actionProperties = null)
    {
        $this->ActionProperties = $actionProperties;
        return $this;
    }
    /**
     * Get RefreshFilter value
     * @return \StructType\PropertyFilterType|null
     */
    public function getRefreshFilter()
    {
        return $this->RefreshFilter;
    }
    /**
     * Set RefreshFilter value
     * @param \StructType\PropertyFilterType $refreshFilter
     * @return \StructType\ChangeRequestType
     */
    public function setRefreshFilter(\StructType\PropertyFilterType $refreshFilter = null)
    {
        $this->RefreshFilter = $refreshFilter;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ChangeRequestType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get updateSequenceNumber value
     * @return int|null
     */
    public function getUpdateSequenceNumber()
    {
        return $this->updateSequenceNumber;
    }
    /**
     * Set updateSequenceNumber value
     * @param int $updateSequenceNumber
     * @return \StructType\ChangeRequestType
     */
    public function setUpdateSequenceNumber($updateSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($updateSequenceNumber) && !(is_int($updateSequenceNumber) || ctype_digit($updateSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateSequenceNumber, true), gettype($updateSequenceNumber)), __LINE__);
        }
        $this->updateSequenceNumber = $updateSequenceNumber;
        return $this;
    }
}
