<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Localization SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Localization $localization
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocalization(\StructType\Localization $localization, $nameSpace = 'http://www.filenet.com/ns/fnce/2006/11/ws/schema', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Localization', $localization, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetObjects
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Localization
     * - SOAPHeaderNamespaces: http://www.filenet.com/ns/fnce/2006/11/ws/schema
     * - SOAPHeaderTypes: \StructType\Localization
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetObjectsRequest $request
     * @return \StructType\GetObjectsResponse|bool
     */
    public function GetObjects(\StructType\GetObjectsRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetObjects($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSearchMetadata
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Localization
     * - SOAPHeaderNamespaces: http://www.filenet.com/ns/fnce/2006/11/ws/schema
     * - SOAPHeaderTypes: \StructType\Localization
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSearchMetadataRequest $request
     * @return \StructType\GetSearchMetadataResponse|bool
     */
    public function GetSearchMetadata(\StructType\GetSearchMetadataRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSearchMetadata($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Localization
     * - SOAPHeaderNamespaces: http://www.filenet.com/ns/fnce/2006/11/ws/schema
     * - SOAPHeaderTypes: \StructType\Localization
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContentRequest $request
     * @return \StructType\GetContentResponse|bool
     */
    public function GetContent(\StructType\GetContentRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->GetContent($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetContentResponse|\StructType\GetObjectsResponse|\StructType\GetSearchMetadataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
