<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsIssueCategory StructType
 * @subpackage Structs
 */
class WsIssueCategory extends AbstractStructBase
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CategoryId;
    /**
     * The CategoryDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryDescription;
    /**
     * Constructor method for WsIssueCategory
     * @uses WsIssueCategory::setCategoryId()
     * @uses WsIssueCategory::setCategoryDescription()
     * @param int $categoryId
     * @param string $categoryDescription
     */
    public function __construct($categoryId = null, $categoryDescription = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setCategoryDescription($categoryDescription);
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\WsIssueCategory
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get CategoryDescription value
     * @return string|null
     */
    public function getCategoryDescription()
    {
        return $this->CategoryDescription;
    }
    /**
     * Set CategoryDescription value
     * @param string $categoryDescription
     * @return \StructType\WsIssueCategory
     */
    public function setCategoryDescription($categoryDescription = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDescription) && !is_string($categoryDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryDescription, true), gettype($categoryDescription)), __LINE__);
        }
        $this->CategoryDescription = $categoryDescription;
        return $this;
    }
}
