<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSupportTicketForDealerInput StructType
 * @subpackage Structs
 */
class UpdateSupportTicketForDealerInput extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueId;
    /**
     * The NewStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewStatus;
    /**
     * The NewOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewOrigin;
    /**
     * The NewPriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewPriority;
    /**
     * The NewCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewCategory;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Resolution;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReasonId;
    /**
     * The Coarse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Coarse;
    /**
     * The ShowCommentToCustomerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowCommentToCustomerAndSendEmail;
    /**
     * The ShowCommentToDealerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowCommentToDealerAndSendEmail;
    /**
     * The IssueDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDesc;
    /**
     * The OwnerLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerLoginName;
    /**
     * The EscalationContactLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EscalationContactLoginName;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for UpdateSupportTicketForDealerInput
     * @uses UpdateSupportTicketForDealerInput::setIssueId()
     * @uses UpdateSupportTicketForDealerInput::setNewStatus()
     * @uses UpdateSupportTicketForDealerInput::setNewOrigin()
     * @uses UpdateSupportTicketForDealerInput::setNewPriority()
     * @uses UpdateSupportTicketForDealerInput::setNewCategory()
     * @uses UpdateSupportTicketForDealerInput::setCustomerId()
     * @uses UpdateSupportTicketForDealerInput::setResolution()
     * @uses UpdateSupportTicketForDealerInput::setReasonId()
     * @uses UpdateSupportTicketForDealerInput::setCoarse()
     * @uses UpdateSupportTicketForDealerInput::setShowCommentToCustomerAndSendEmail()
     * @uses UpdateSupportTicketForDealerInput::setShowCommentToDealerAndSendEmail()
     * @uses UpdateSupportTicketForDealerInput::setIssueDesc()
     * @uses UpdateSupportTicketForDealerInput::setOwnerLoginName()
     * @uses UpdateSupportTicketForDealerInput::setEscalationContactLoginName()
     * @uses UpdateSupportTicketForDealerInput::setComment()
     * @param int $issueId
     * @param string $newStatus
     * @param string $newOrigin
     * @param string $newPriority
     * @param string $newCategory
     * @param int $customerId
     * @param string $resolution
     * @param int $reasonId
     * @param int $coarse
     * @param bool $showCommentToCustomerAndSendEmail
     * @param bool $showCommentToDealerAndSendEmail
     * @param string $issueDesc
     * @param string $ownerLoginName
     * @param string $escalationContactLoginName
     * @param string $comment
     */
    public function __construct($issueId = null, $newStatus = null, $newOrigin = null, $newPriority = null, $newCategory = null, $customerId = null, $resolution = null, $reasonId = null, $coarse = null, $showCommentToCustomerAndSendEmail = null, $showCommentToDealerAndSendEmail = null, $issueDesc = null, $ownerLoginName = null, $escalationContactLoginName = null, $comment = null)
    {
        $this
            ->setIssueId($issueId)
            ->setNewStatus($newStatus)
            ->setNewOrigin($newOrigin)
            ->setNewPriority($newPriority)
            ->setNewCategory($newCategory)
            ->setCustomerId($customerId)
            ->setResolution($resolution)
            ->setReasonId($reasonId)
            ->setCoarse($coarse)
            ->setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail)
            ->setShowCommentToDealerAndSendEmail($showCommentToDealerAndSendEmail)
            ->setIssueDesc($issueDesc)
            ->setOwnerLoginName($ownerLoginName)
            ->setEscalationContactLoginName($escalationContactLoginName)
            ->setComment($comment);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get NewStatus value
     * @return string
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @uses \EnumType\IssueStatusEnum::valueIsValid()
     * @uses \EnumType\IssueStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueStatusEnum::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueStatusEnum', is_array($newStatus) ? implode(', ', $newStatus) : var_export($newStatus, true), implode(', ', \EnumType\IssueStatusEnum::getValidValues())), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get NewOrigin value
     * @return string
     */
    public function getNewOrigin()
    {
        return $this->NewOrigin;
    }
    /**
     * Set NewOrigin value
     * @uses \EnumType\IssueOriginEnum::valueIsValid()
     * @uses \EnumType\IssueOriginEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newOrigin
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setNewOrigin($newOrigin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueOriginEnum::valueIsValid($newOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueOriginEnum', is_array($newOrigin) ? implode(', ', $newOrigin) : var_export($newOrigin, true), implode(', ', \EnumType\IssueOriginEnum::getValidValues())), __LINE__);
        }
        $this->NewOrigin = $newOrigin;
        return $this;
    }
    /**
     * Get NewPriority value
     * @return string
     */
    public function getNewPriority()
    {
        return $this->NewPriority;
    }
    /**
     * Set NewPriority value
     * @uses \EnumType\IssuePriorityEnum::valueIsValid()
     * @uses \EnumType\IssuePriorityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newPriority
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setNewPriority($newPriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssuePriorityEnum::valueIsValid($newPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssuePriorityEnum', is_array($newPriority) ? implode(', ', $newPriority) : var_export($newPriority, true), implode(', ', \EnumType\IssuePriorityEnum::getValidValues())), __LINE__);
        }
        $this->NewPriority = $newPriority;
        return $this;
    }
    /**
     * Get NewCategory value
     * @return string
     */
    public function getNewCategory()
    {
        return $this->NewCategory;
    }
    /**
     * Set NewCategory value
     * @uses \EnumType\IssueCategoryEnum::valueIsValid()
     * @uses \EnumType\IssueCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newCategory
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setNewCategory($newCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueCategoryEnum::valueIsValid($newCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueCategoryEnum', is_array($newCategory) ? implode(', ', $newCategory) : var_export($newCategory, true), implode(', ', \EnumType\IssueCategoryEnum::getValidValues())), __LINE__);
        }
        $this->NewCategory = $newCategory;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Resolution value
     * @return string
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @uses \EnumType\IssueResolutionEnum::valueIsValid()
     * @uses \EnumType\IssueResolutionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resolution
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueResolutionEnum::valueIsValid($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueResolutionEnum', is_array($resolution) ? implode(', ', $resolution) : var_export($resolution, true), implode(', ', \EnumType\IssueResolutionEnum::getValidValues())), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get ReasonId value
     * @return int
     */
    public function getReasonId()
    {
        return $this->ReasonId;
    }
    /**
     * Set ReasonId value
     * @param int $reasonId
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: int
        if (!is_null($reasonId) && !(is_int($reasonId) || ctype_digit($reasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        $this->ReasonId = $reasonId;
        return $this;
    }
    /**
     * Get Coarse value
     * @return int
     */
    public function getCoarse()
    {
        return $this->Coarse;
    }
    /**
     * Set Coarse value
     * @param int $coarse
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setCoarse($coarse = null)
    {
        // validation for constraint: int
        if (!is_null($coarse) && !(is_int($coarse) || ctype_digit($coarse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coarse, true), gettype($coarse)), __LINE__);
        }
        $this->Coarse = $coarse;
        return $this;
    }
    /**
     * Get ShowCommentToCustomerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToCustomerAndSendEmail()
    {
        return $this->ShowCommentToCustomerAndSendEmail;
    }
    /**
     * Set ShowCommentToCustomerAndSendEmail value
     * @param bool $showCommentToCustomerAndSendEmail
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToCustomerAndSendEmail) && !is_bool($showCommentToCustomerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToCustomerAndSendEmail, true), gettype($showCommentToCustomerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToCustomerAndSendEmail = $showCommentToCustomerAndSendEmail;
        return $this;
    }
    /**
     * Get ShowCommentToDealerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToDealerAndSendEmail()
    {
        return $this->ShowCommentToDealerAndSendEmail;
    }
    /**
     * Set ShowCommentToDealerAndSendEmail value
     * @param bool $showCommentToDealerAndSendEmail
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setShowCommentToDealerAndSendEmail($showCommentToDealerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToDealerAndSendEmail) && !is_bool($showCommentToDealerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToDealerAndSendEmail, true), gettype($showCommentToDealerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToDealerAndSendEmail = $showCommentToDealerAndSendEmail;
        return $this;
    }
    /**
     * Get IssueDesc value
     * @return string|null
     */
    public function getIssueDesc()
    {
        return $this->IssueDesc;
    }
    /**
     * Set IssueDesc value
     * @param string $issueDesc
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setIssueDesc($issueDesc = null)
    {
        // validation for constraint: string
        if (!is_null($issueDesc) && !is_string($issueDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDesc, true), gettype($issueDesc)), __LINE__);
        }
        $this->IssueDesc = $issueDesc;
        return $this;
    }
    /**
     * Get OwnerLoginName value
     * @return string|null
     */
    public function getOwnerLoginName()
    {
        return $this->OwnerLoginName;
    }
    /**
     * Set OwnerLoginName value
     * @param string $ownerLoginName
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setOwnerLoginName($ownerLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerLoginName) && !is_string($ownerLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerLoginName, true), gettype($ownerLoginName)), __LINE__);
        }
        $this->OwnerLoginName = $ownerLoginName;
        return $this;
    }
    /**
     * Get EscalationContactLoginName value
     * @return string|null
     */
    public function getEscalationContactLoginName()
    {
        return $this->EscalationContactLoginName;
    }
    /**
     * Set EscalationContactLoginName value
     * @param string $escalationContactLoginName
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setEscalationContactLoginName($escalationContactLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($escalationContactLoginName) && !is_string($escalationContactLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($escalationContactLoginName, true), gettype($escalationContactLoginName)), __LINE__);
        }
        $this->EscalationContactLoginName = $escalationContactLoginName;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\UpdateSupportTicketForDealerInput
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
