<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateRepInput StructType
 * @subpackage Structs
 */
class TerminateRepInput extends AbstractStructBase
{
    /**
     * The RepIdToTerminate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepIdToTerminate;
    /**
     * The RepIdToAssignCustomersTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepIdToAssignCustomersTo;
    /**
     * Constructor method for TerminateRepInput
     * @uses TerminateRepInput::setRepIdToTerminate()
     * @uses TerminateRepInput::setRepIdToAssignCustomersTo()
     * @param int $repIdToTerminate
     * @param int $repIdToAssignCustomersTo
     */
    public function __construct($repIdToTerminate = null, $repIdToAssignCustomersTo = null)
    {
        $this
            ->setRepIdToTerminate($repIdToTerminate)
            ->setRepIdToAssignCustomersTo($repIdToAssignCustomersTo);
    }
    /**
     * Get RepIdToTerminate value
     * @return int
     */
    public function getRepIdToTerminate()
    {
        return $this->RepIdToTerminate;
    }
    /**
     * Set RepIdToTerminate value
     * @param int $repIdToTerminate
     * @return \StructType\TerminateRepInput
     */
    public function setRepIdToTerminate($repIdToTerminate = null)
    {
        // validation for constraint: int
        if (!is_null($repIdToTerminate) && !(is_int($repIdToTerminate) || ctype_digit($repIdToTerminate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repIdToTerminate, true), gettype($repIdToTerminate)), __LINE__);
        }
        $this->RepIdToTerminate = $repIdToTerminate;
        return $this;
    }
    /**
     * Get RepIdToAssignCustomersTo value
     * @return int
     */
    public function getRepIdToAssignCustomersTo()
    {
        return $this->RepIdToAssignCustomersTo;
    }
    /**
     * Set RepIdToAssignCustomersTo value
     * @param int $repIdToAssignCustomersTo
     * @return \StructType\TerminateRepInput
     */
    public function setRepIdToAssignCustomersTo($repIdToAssignCustomersTo = null)
    {
        // validation for constraint: int
        if (!is_null($repIdToAssignCustomersTo) && !(is_int($repIdToAssignCustomersTo) || ctype_digit($repIdToAssignCustomersTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repIdToAssignCustomersTo, true), gettype($repIdToAssignCustomersTo)), __LINE__);
        }
        $this->RepIdToAssignCustomersTo = $repIdToAssignCustomersTo;
        return $this;
    }
}
