<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelTemplateInfo StructType
 * @subpackage Structs
 */
class PanelTemplateInfo extends AbstractStructBase
{
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TemplateId;
    /**
     * The PanelVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelVersion;
    /**
     * The PanelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelType;
    /**
     * The LastChangedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastChangedDate;
    /**
     * The LastChangerSupportId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LastChangerSupportId;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The TemplateDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateDesc;
    /**
     * Constructor method for PanelTemplateInfo
     * @uses PanelTemplateInfo::setTemplateId()
     * @uses PanelTemplateInfo::setPanelVersion()
     * @uses PanelTemplateInfo::setPanelType()
     * @uses PanelTemplateInfo::setLastChangedDate()
     * @uses PanelTemplateInfo::setLastChangerSupportId()
     * @uses PanelTemplateInfo::setIsDefault()
     * @uses PanelTemplateInfo::setTemplateDesc()
     * @param int $templateId
     * @param string $panelVersion
     * @param string $panelType
     * @param string $lastChangedDate
     * @param int $lastChangerSupportId
     * @param bool $isDefault
     * @param string $templateDesc
     */
    public function __construct($templateId = null, $panelVersion = null, $panelType = null, $lastChangedDate = null, $lastChangerSupportId = null, $isDefault = null, $templateDesc = null)
    {
        $this
            ->setTemplateId($templateId)
            ->setPanelVersion($panelVersion)
            ->setPanelType($panelType)
            ->setLastChangedDate($lastChangedDate)
            ->setLastChangerSupportId($lastChangerSupportId)
            ->setIsDefault($isDefault)
            ->setTemplateDesc($templateDesc);
    }
    /**
     * Get TemplateId value
     * @return int
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return \StructType\PanelTemplateInfo
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !(is_int($templateId) || ctype_digit($templateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get PanelVersion value
     * @return string
     */
    public function getPanelVersion()
    {
        return $this->PanelVersion;
    }
    /**
     * Set PanelVersion value
     * @uses \EnumType\PanelVersionEnum::valueIsValid()
     * @uses \EnumType\PanelVersionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelVersion
     * @return \StructType\PanelTemplateInfo
     */
    public function setPanelVersion($panelVersion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PanelVersionEnum::valueIsValid($panelVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PanelVersionEnum', is_array($panelVersion) ? implode(', ', $panelVersion) : var_export($panelVersion, true), implode(', ', \EnumType\PanelVersionEnum::getValidValues())), __LINE__);
        }
        $this->PanelVersion = $panelVersion;
        return $this;
    }
    /**
     * Get PanelType value
     * @return string
     */
    public function getPanelType()
    {
        return $this->PanelType;
    }
    /**
     * Set PanelType value
     * @uses \EnumType\PanelTypeEnum::valueIsValid()
     * @uses \EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelType
     * @return \StructType\PanelTemplateInfo
     */
    public function setPanelType($panelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PanelTypeEnum::valueIsValid($panelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PanelTypeEnum', is_array($panelType) ? implode(', ', $panelType) : var_export($panelType, true), implode(', ', \EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->PanelType = $panelType;
        return $this;
    }
    /**
     * Get LastChangedDate value
     * @return string
     */
    public function getLastChangedDate()
    {
        return $this->LastChangedDate;
    }
    /**
     * Set LastChangedDate value
     * @param string $lastChangedDate
     * @return \StructType\PanelTemplateInfo
     */
    public function setLastChangedDate($lastChangedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastChangedDate) && !is_string($lastChangedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChangedDate, true), gettype($lastChangedDate)), __LINE__);
        }
        $this->LastChangedDate = $lastChangedDate;
        return $this;
    }
    /**
     * Get LastChangerSupportId value
     * @return int
     */
    public function getLastChangerSupportId()
    {
        return $this->LastChangerSupportId;
    }
    /**
     * Set LastChangerSupportId value
     * @param int $lastChangerSupportId
     * @return \StructType\PanelTemplateInfo
     */
    public function setLastChangerSupportId($lastChangerSupportId = null)
    {
        // validation for constraint: int
        if (!is_null($lastChangerSupportId) && !(is_int($lastChangerSupportId) || ctype_digit($lastChangerSupportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastChangerSupportId, true), gettype($lastChangerSupportId)), __LINE__);
        }
        $this->LastChangerSupportId = $lastChangerSupportId;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\PanelTemplateInfo
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get TemplateDesc value
     * @return string|null
     */
    public function getTemplateDesc()
    {
        return $this->TemplateDesc;
    }
    /**
     * Set TemplateDesc value
     * @param string $templateDesc
     * @return \StructType\PanelTemplateInfo
     */
    public function setTemplateDesc($templateDesc = null)
    {
        // validation for constraint: string
        if (!is_null($templateDesc) && !is_string($templateDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateDesc, true), gettype($templateDesc)), __LINE__);
        }
        $this->TemplateDesc = $templateDesc;
        return $this;
    }
}
