<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWizardWebResponseOutput StructType
 * @subpackage Structs
 */
class GetWizardWebResponseOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The WizardUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WizardUrl;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetWizardWebResponseOutput
     * @uses GetWizardWebResponseOutput::setSuccess()
     * @uses GetWizardWebResponseOutput::setWizardUrl()
     * @uses GetWizardWebResponseOutput::setErrorMessage()
     * @param bool $success
     * @param string $wizardUrl
     * @param string $errorMessage
     */
    public function __construct($success = null, $wizardUrl = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setWizardUrl($wizardUrl)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetWizardWebResponseOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get WizardUrl value
     * @return string|null
     */
    public function getWizardUrl()
    {
        return $this->WizardUrl;
    }
    /**
     * Set WizardUrl value
     * @param string $wizardUrl
     * @return \StructType\GetWizardWebResponseOutput
     */
    public function setWizardUrl($wizardUrl = null)
    {
        // validation for constraint: string
        if (!is_null($wizardUrl) && !is_string($wizardUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wizardUrl, true), gettype($wizardUrl)), __LINE__);
        }
        $this->WizardUrl = $wizardUrl;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetWizardWebResponseOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
