<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSupportTicketsInput StructType
 * @subpackage Structs
 */
class GetSupportTicketsInput extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IssueId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Priority;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CategoryId;
    /**
     * The ExcludeTicketsSubmittedByCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExcludeTicketsSubmittedByCustomer;
    /**
     * The CustomerIssuesOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CustomerIssuesOnly;
    /**
     * The Keyword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Keyword;
    /**
     * Constructor method for GetSupportTicketsInput
     * @uses GetSupportTicketsInput::setIssueId()
     * @uses GetSupportTicketsInput::setCustomerId()
     * @uses GetSupportTicketsInput::setDealerId()
     * @uses GetSupportTicketsInput::setFromDate()
     * @uses GetSupportTicketsInput::setToDate()
     * @uses GetSupportTicketsInput::setStatus()
     * @uses GetSupportTicketsInput::setPriority()
     * @uses GetSupportTicketsInput::setCategoryId()
     * @uses GetSupportTicketsInput::setExcludeTicketsSubmittedByCustomer()
     * @uses GetSupportTicketsInput::setCustomerIssuesOnly()
     * @uses GetSupportTicketsInput::setKeyword()
     * @param int $issueId
     * @param int $customerId
     * @param int $dealerId
     * @param string $fromDate
     * @param string $toDate
     * @param string $status
     * @param string $priority
     * @param int $categoryId
     * @param bool $excludeTicketsSubmittedByCustomer
     * @param bool $customerIssuesOnly
     * @param string $keyword
     */
    public function __construct($issueId = null, $customerId = null, $dealerId = null, $fromDate = null, $toDate = null, $status = null, $priority = null, $categoryId = null, $excludeTicketsSubmittedByCustomer = null, $customerIssuesOnly = null, $keyword = null)
    {
        $this
            ->setIssueId($issueId)
            ->setCustomerId($customerId)
            ->setDealerId($dealerId)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setStatus($status)
            ->setPriority($priority)
            ->setCategoryId($categoryId)
            ->setExcludeTicketsSubmittedByCustomer($excludeTicketsSubmittedByCustomer)
            ->setCustomerIssuesOnly($customerIssuesOnly)
            ->setKeyword($keyword);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\GetSupportTicketsInput
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\GetSupportTicketsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \StructType\GetSupportTicketsInput
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \StructType\GetSupportTicketsInput
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \StructType\GetSupportTicketsInput
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\IssueStatusEnum::valueIsValid()
     * @uses \EnumType\IssueStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\GetSupportTicketsInput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\IssueStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @uses \EnumType\IssuePriorityEnum::valueIsValid()
     * @uses \EnumType\IssuePriorityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\GetSupportTicketsInput
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssuePriorityEnum::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssuePriorityEnum', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \EnumType\IssuePriorityEnum::getValidValues())), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return int
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param int $categoryId
     * @return \StructType\GetSupportTicketsInput
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: int
        if (!is_null($categoryId) && !(is_int($categoryId) || ctype_digit($categoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get ExcludeTicketsSubmittedByCustomer value
     * @return bool
     */
    public function getExcludeTicketsSubmittedByCustomer()
    {
        return $this->ExcludeTicketsSubmittedByCustomer;
    }
    /**
     * Set ExcludeTicketsSubmittedByCustomer value
     * @param bool $excludeTicketsSubmittedByCustomer
     * @return \StructType\GetSupportTicketsInput
     */
    public function setExcludeTicketsSubmittedByCustomer($excludeTicketsSubmittedByCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeTicketsSubmittedByCustomer) && !is_bool($excludeTicketsSubmittedByCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeTicketsSubmittedByCustomer, true), gettype($excludeTicketsSubmittedByCustomer)), __LINE__);
        }
        $this->ExcludeTicketsSubmittedByCustomer = $excludeTicketsSubmittedByCustomer;
        return $this;
    }
    /**
     * Get CustomerIssuesOnly value
     * @return bool
     */
    public function getCustomerIssuesOnly()
    {
        return $this->CustomerIssuesOnly;
    }
    /**
     * Set CustomerIssuesOnly value
     * @param bool $customerIssuesOnly
     * @return \StructType\GetSupportTicketsInput
     */
    public function setCustomerIssuesOnly($customerIssuesOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerIssuesOnly) && !is_bool($customerIssuesOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerIssuesOnly, true), gettype($customerIssuesOnly)), __LINE__);
        }
        $this->CustomerIssuesOnly = $customerIssuesOnly;
        return $this;
    }
    /**
     * Get Keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param string $keyword
     * @return \StructType\GetSupportTicketsInput
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyword, true), gettype($keyword)), __LINE__);
        }
        $this->Keyword = $keyword;
        return $this;
    }
}
