<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRepIdByEmployeeIdInput StructType
 * @subpackage Structs
 */
class GetRepIdByEmployeeIdInput extends AbstractStructBase
{
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The EmployeeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmployeeId;
    /**
     * Constructor method for GetRepIdByEmployeeIdInput
     * @uses GetRepIdByEmployeeIdInput::setBranchId()
     * @uses GetRepIdByEmployeeIdInput::setEmployeeId()
     * @param int $branchId
     * @param string $employeeId
     */
    public function __construct($branchId = null, $employeeId = null)
    {
        $this
            ->setBranchId($branchId)
            ->setEmployeeId($employeeId);
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \StructType\GetRepIdByEmployeeIdInput
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get EmployeeId value
     * @return string|null
     */
    public function getEmployeeId()
    {
        return $this->EmployeeId;
    }
    /**
     * Set EmployeeId value
     * @param string $employeeId
     * @return \StructType\GetRepIdByEmployeeIdInput
     */
    public function setEmployeeId($employeeId = null)
    {
        // validation for constraint: string
        if (!is_null($employeeId) && !is_string($employeeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeId, true), gettype($employeeId)), __LINE__);
        }
        $this->EmployeeId = $employeeId;
        return $this;
    }
}
