<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDealerIdOutput StructType
 * @subpackage Structs
 */
class GetDealerIdOutput extends AbstractStructBase
{
    /**
     * The DealerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DealerID;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The DealerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerName;
    /**
     * The SubDealers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBranchInfo
     */
    public $SubDealers;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetDealerIdOutput
     * @uses GetDealerIdOutput::setDealerID()
     * @uses GetDealerIdOutput::setSuccess()
     * @uses GetDealerIdOutput::setDealerName()
     * @uses GetDealerIdOutput::setSubDealers()
     * @uses GetDealerIdOutput::setErrorMessage()
     * @param int $dealerID
     * @param bool $success
     * @param string $dealerName
     * @param \ArrayType\ArrayOfBranchInfo $subDealers
     * @param string $errorMessage
     */
    public function __construct($dealerID = null, $success = null, $dealerName = null, \ArrayType\ArrayOfBranchInfo $subDealers = null, $errorMessage = null)
    {
        $this
            ->setDealerID($dealerID)
            ->setSuccess($success)
            ->setDealerName($dealerName)
            ->setSubDealers($subDealers)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get DealerID value
     * @return int
     */
    public function getDealerID()
    {
        return $this->DealerID;
    }
    /**
     * Set DealerID value
     * @param int $dealerID
     * @return \StructType\GetDealerIdOutput
     */
    public function setDealerID($dealerID = null)
    {
        // validation for constraint: int
        if (!is_null($dealerID) && !(is_int($dealerID) || ctype_digit($dealerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerID, true), gettype($dealerID)), __LINE__);
        }
        $this->DealerID = $dealerID;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetDealerIdOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get DealerName value
     * @return string|null
     */
    public function getDealerName()
    {
        return $this->DealerName;
    }
    /**
     * Set DealerName value
     * @param string $dealerName
     * @return \StructType\GetDealerIdOutput
     */
    public function setDealerName($dealerName = null)
    {
        // validation for constraint: string
        if (!is_null($dealerName) && !is_string($dealerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerName, true), gettype($dealerName)), __LINE__);
        }
        $this->DealerName = $dealerName;
        return $this;
    }
    /**
     * Get SubDealers value
     * @return \ArrayType\ArrayOfBranchInfo|null
     */
    public function getSubDealers()
    {
        return $this->SubDealers;
    }
    /**
     * Set SubDealers value
     * @param \ArrayType\ArrayOfBranchInfo $subDealers
     * @return \StructType\GetDealerIdOutput
     */
    public function setSubDealers(\ArrayType\ArrayOfBranchInfo $subDealers = null)
    {
        $this->SubDealers = $subDealers;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetDealerIdOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
