<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCurrentRepInfoOutput StructType
 * @subpackage Structs
 */
class GetCurrentRepInfoOutput extends AbstractStructBase
{
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The RoledIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $RoledIds;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The RepAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressWithName
     */
    public $RepAddress;
    /**
     * The RepPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepPhoneNumber;
    /**
     * The RepEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepEmail;
    /**
     * The RepDepartments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerRepDepartmentEnum
     */
    public $RepDepartments;
    /**
     * The RepMarketingPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum
     */
    public $RepMarketingPreferences;
    /**
     * The IpMaskForLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpMaskForLogin;
    /**
     * The RepLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLoginName;
    /**
     * Constructor method for GetCurrentRepInfoOutput
     * @uses GetCurrentRepInfoOutput::setRepId()
     * @uses GetCurrentRepInfoOutput::setBranchId()
     * @uses GetCurrentRepInfoOutput::setSuccess()
     * @uses GetCurrentRepInfoOutput::setRoledIds()
     * @uses GetCurrentRepInfoOutput::setErrorMessage()
     * @uses GetCurrentRepInfoOutput::setRepAddress()
     * @uses GetCurrentRepInfoOutput::setRepPhoneNumber()
     * @uses GetCurrentRepInfoOutput::setRepEmail()
     * @uses GetCurrentRepInfoOutput::setRepDepartments()
     * @uses GetCurrentRepInfoOutput::setRepMarketingPreferences()
     * @uses GetCurrentRepInfoOutput::setIpMaskForLogin()
     * @uses GetCurrentRepInfoOutput::setRepLoginName()
     * @param int $repId
     * @param int $branchId
     * @param bool $success
     * @param \ArrayType\ArrayOfInt $roledIds
     * @param string $errorMessage
     * @param \StructType\AddressWithName $repAddress
     * @param string $repPhoneNumber
     * @param string $repEmail
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences
     * @param string $ipMaskForLogin
     * @param string $repLoginName
     */
    public function __construct($repId = null, $branchId = null, $success = null, \ArrayType\ArrayOfInt $roledIds = null, $errorMessage = null, \StructType\AddressWithName $repAddress = null, $repPhoneNumber = null, $repEmail = null, \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments = null, \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences = null, $ipMaskForLogin = null, $repLoginName = null)
    {
        $this
            ->setRepId($repId)
            ->setBranchId($branchId)
            ->setSuccess($success)
            ->setRoledIds($roledIds)
            ->setErrorMessage($errorMessage)
            ->setRepAddress($repAddress)
            ->setRepPhoneNumber($repPhoneNumber)
            ->setRepEmail($repEmail)
            ->setRepDepartments($repDepartments)
            ->setRepMarketingPreferences($repMarketingPreferences)
            ->setIpMaskForLogin($ipMaskForLogin)
            ->setRepLoginName($repLoginName);
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get RoledIds value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRoledIds()
    {
        return $this->RoledIds;
    }
    /**
     * Set RoledIds value
     * @param \ArrayType\ArrayOfInt $roledIds
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRoledIds(\ArrayType\ArrayOfInt $roledIds = null)
    {
        $this->RoledIds = $roledIds;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get RepAddress value
     * @return \StructType\AddressWithName|null
     */
    public function getRepAddress()
    {
        return $this->RepAddress;
    }
    /**
     * Set RepAddress value
     * @param \StructType\AddressWithName $repAddress
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepAddress(\StructType\AddressWithName $repAddress = null)
    {
        $this->RepAddress = $repAddress;
        return $this;
    }
    /**
     * Get RepPhoneNumber value
     * @return string|null
     */
    public function getRepPhoneNumber()
    {
        return $this->RepPhoneNumber;
    }
    /**
     * Set RepPhoneNumber value
     * @param string $repPhoneNumber
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepPhoneNumber($repPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($repPhoneNumber) && !is_string($repPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repPhoneNumber, true), gettype($repPhoneNumber)), __LINE__);
        }
        $this->RepPhoneNumber = $repPhoneNumber;
        return $this;
    }
    /**
     * Get RepEmail value
     * @return string|null
     */
    public function getRepEmail()
    {
        return $this->RepEmail;
    }
    /**
     * Set RepEmail value
     * @param string $repEmail
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepEmail($repEmail = null)
    {
        // validation for constraint: string
        if (!is_null($repEmail) && !is_string($repEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repEmail, true), gettype($repEmail)), __LINE__);
        }
        $this->RepEmail = $repEmail;
        return $this;
    }
    /**
     * Get RepDepartments value
     * @return \ArrayType\ArrayOfCustomerRepDepartmentEnum|null
     */
    public function getRepDepartments()
    {
        return $this->RepDepartments;
    }
    /**
     * Set RepDepartments value
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepDepartments(\ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments = null)
    {
        $this->RepDepartments = $repDepartments;
        return $this;
    }
    /**
     * Get RepMarketingPreferences value
     * @return \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum|null
     */
    public function getRepMarketingPreferences()
    {
        return $this->RepMarketingPreferences;
    }
    /**
     * Set RepMarketingPreferences value
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepMarketingPreferences(\ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences = null)
    {
        $this->RepMarketingPreferences = $repMarketingPreferences;
        return $this;
    }
    /**
     * Get IpMaskForLogin value
     * @return string|null
     */
    public function getIpMaskForLogin()
    {
        return $this->IpMaskForLogin;
    }
    /**
     * Set IpMaskForLogin value
     * @param string $ipMaskForLogin
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setIpMaskForLogin($ipMaskForLogin = null)
    {
        // validation for constraint: string
        if (!is_null($ipMaskForLogin) && !is_string($ipMaskForLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipMaskForLogin, true), gettype($ipMaskForLogin)), __LINE__);
        }
        $this->IpMaskForLogin = $ipMaskForLogin;
        return $this;
    }
    /**
     * Get RepLoginName value
     * @return string|null
     */
    public function getRepLoginName()
    {
        return $this->RepLoginName;
    }
    /**
     * Set RepLoginName value
     * @param string $repLoginName
     * @return \StructType\GetCurrentRepInfoOutput
     */
    public function setRepLoginName($repLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($repLoginName) && !is_string($repLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repLoginName, true), gettype($repLoginName)), __LINE__);
        }
        $this->RepLoginName = $repLoginName;
        return $this;
    }
}
