<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBranchInput StructType
 * @subpackage Structs
 */
class CreateBranchInput extends AbstractStructBase
{
    /**
     * The BranchType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BranchType;
    /**
     * The BranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchName;
    /**
     * The BranchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $BranchAddress;
    /**
     * The ContactPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPhoneNumber;
    /**
     * The ContactEmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactEmailAddress;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * Constructor method for CreateBranchInput
     * @uses CreateBranchInput::setBranchType()
     * @uses CreateBranchInput::setBranchName()
     * @uses CreateBranchInput::setBranchAddress()
     * @uses CreateBranchInput::setContactPhoneNumber()
     * @uses CreateBranchInput::setContactEmailAddress()
     * @uses CreateBranchInput::setContactName()
     * @uses CreateBranchInput::setBranchCode()
     * @param string $branchType
     * @param string $branchName
     * @param \StructType\Address $branchAddress
     * @param string $contactPhoneNumber
     * @param string $contactEmailAddress
     * @param string $contactName
     * @param string $branchCode
     */
    public function __construct($branchType = null, $branchName = null, \StructType\Address $branchAddress = null, $contactPhoneNumber = null, $contactEmailAddress = null, $contactName = null, $branchCode = null)
    {
        $this
            ->setBranchType($branchType)
            ->setBranchName($branchName)
            ->setBranchAddress($branchAddress)
            ->setContactPhoneNumber($contactPhoneNumber)
            ->setContactEmailAddress($contactEmailAddress)
            ->setContactName($contactName)
            ->setBranchCode($branchCode);
    }
    /**
     * Get BranchType value
     * @return string
     */
    public function getBranchType()
    {
        return $this->BranchType;
    }
    /**
     * Set BranchType value
     * @uses \EnumType\BranchType::valueIsValid()
     * @uses \EnumType\BranchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $branchType
     * @return \StructType\CreateBranchInput
     */
    public function setBranchType($branchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BranchType::valueIsValid($branchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BranchType', is_array($branchType) ? implode(', ', $branchType) : var_export($branchType, true), implode(', ', \EnumType\BranchType::getValidValues())), __LINE__);
        }
        $this->BranchType = $branchType;
        return $this;
    }
    /**
     * Get BranchName value
     * @return string|null
     */
    public function getBranchName()
    {
        return $this->BranchName;
    }
    /**
     * Set BranchName value
     * @param string $branchName
     * @return \StructType\CreateBranchInput
     */
    public function setBranchName($branchName = null)
    {
        // validation for constraint: string
        if (!is_null($branchName) && !is_string($branchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchName, true), gettype($branchName)), __LINE__);
        }
        $this->BranchName = $branchName;
        return $this;
    }
    /**
     * Get BranchAddress value
     * @return \StructType\Address|null
     */
    public function getBranchAddress()
    {
        return $this->BranchAddress;
    }
    /**
     * Set BranchAddress value
     * @param \StructType\Address $branchAddress
     * @return \StructType\CreateBranchInput
     */
    public function setBranchAddress(\StructType\Address $branchAddress = null)
    {
        $this->BranchAddress = $branchAddress;
        return $this;
    }
    /**
     * Get ContactPhoneNumber value
     * @return string|null
     */
    public function getContactPhoneNumber()
    {
        return $this->ContactPhoneNumber;
    }
    /**
     * Set ContactPhoneNumber value
     * @param string $contactPhoneNumber
     * @return \StructType\CreateBranchInput
     */
    public function setContactPhoneNumber($contactPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contactPhoneNumber) && !is_string($contactPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPhoneNumber, true), gettype($contactPhoneNumber)), __LINE__);
        }
        $this->ContactPhoneNumber = $contactPhoneNumber;
        return $this;
    }
    /**
     * Get ContactEmailAddress value
     * @return string|null
     */
    public function getContactEmailAddress()
    {
        return $this->ContactEmailAddress;
    }
    /**
     * Set ContactEmailAddress value
     * @param string $contactEmailAddress
     * @return \StructType\CreateBranchInput
     */
    public function setContactEmailAddress($contactEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmailAddress) && !is_string($contactEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmailAddress, true), gettype($contactEmailAddress)), __LINE__);
        }
        $this->ContactEmailAddress = $contactEmailAddress;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\CreateBranchInput
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }
    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return \StructType\CreateBranchInput
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }
}
