<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication StructType
 * Meta information extracted from the WSDL
 * - type: tns:Authentication
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The TwoFactorDeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TwoFactorDeviceId;
    /**
     * Constructor method for Authentication
     * @uses Authentication::setUser()
     * @uses Authentication::setPassword()
     * @uses Authentication::setTwoFactorDeviceId()
     * @param string $user
     * @param string $password
     * @param string $twoFactorDeviceId
     */
    public function __construct($user = null, $password = null, $twoFactorDeviceId = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setTwoFactorDeviceId($twoFactorDeviceId);
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \StructType\Authentication
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Authentication
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get TwoFactorDeviceId value
     * @return string|null
     */
    public function getTwoFactorDeviceId()
    {
        return $this->TwoFactorDeviceId;
    }
    /**
     * Set TwoFactorDeviceId value
     * @param string $twoFactorDeviceId
     * @return \StructType\Authentication
     */
    public function setTwoFactorDeviceId($twoFactorDeviceId = null)
    {
        // validation for constraint: string
        if (!is_null($twoFactorDeviceId) && !is_string($twoFactorDeviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($twoFactorDeviceId, true), gettype($twoFactorDeviceId)), __LINE__);
        }
        $this->TwoFactorDeviceId = $twoFactorDeviceId;
        return $this;
    }
}
