<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddToBinderInput StructType
 * @subpackage Structs
 */
class AddToBinderInput extends AbstractStructBase
{
    /**
     * The RecipientRepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RecipientRepId;
    /**
     * The Bookmark
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Bookmark;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for AddToBinderInput
     * @uses AddToBinderInput::setRecipientRepId()
     * @uses AddToBinderInput::setBookmark()
     * @uses AddToBinderInput::setTitle()
     * @uses AddToBinderInput::setUrl()
     * @param int $recipientRepId
     * @param bool $bookmark
     * @param string $title
     * @param string $url
     */
    public function __construct($recipientRepId = null, $bookmark = null, $title = null, $url = null)
    {
        $this
            ->setRecipientRepId($recipientRepId)
            ->setBookmark($bookmark)
            ->setTitle($title)
            ->setUrl($url);
    }
    /**
     * Get RecipientRepId value
     * @return int
     */
    public function getRecipientRepId()
    {
        return $this->RecipientRepId;
    }
    /**
     * Set RecipientRepId value
     * @param int $recipientRepId
     * @return \StructType\AddToBinderInput
     */
    public function setRecipientRepId($recipientRepId = null)
    {
        // validation for constraint: int
        if (!is_null($recipientRepId) && !(is_int($recipientRepId) || ctype_digit($recipientRepId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recipientRepId, true), gettype($recipientRepId)), __LINE__);
        }
        $this->RecipientRepId = $recipientRepId;
        return $this;
    }
    /**
     * Get Bookmark value
     * @return bool
     */
    public function getBookmark()
    {
        return $this->Bookmark;
    }
    /**
     * Set Bookmark value
     * @param bool $bookmark
     * @return \StructType\AddToBinderInput
     */
    public function setBookmark($bookmark = null)
    {
        // validation for constraint: boolean
        if (!is_null($bookmark) && !is_bool($bookmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bookmark, true), gettype($bookmark)), __LINE__);
        }
        $this->Bookmark = $bookmark;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\AddToBinderInput
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\AddToBinderInput
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
}
