<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GenerateRepLoginTokenForSSO
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retrieve a login token for a rep to use for SSO into ADC's dealer tools.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateRepLoginTokenForSSO $parameters
     * @return \StructType\GenerateRepLoginTokenForSSOResponse|bool
     */
    public function GenerateRepLoginTokenForSSO(\StructType\GenerateRepLoginTokenForSSO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateRepLoginTokenForSSO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GenerateRepLoginUrlForSSOMobileTechApp
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Generate the url for a rep to SSO into Alarm.com MobileTech App.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateRepLoginUrlForSSOMobileTechApp $parameters
     * @return \StructType\GenerateRepLoginUrlForSSOMobileTechAppResponse|bool
     */
    public function GenerateRepLoginUrlForSSOMobileTechApp(\StructType\GenerateRepLoginUrlForSSOMobileTechApp $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GenerateRepLoginUrlForSSOMobileTechApp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenerateRepLoginTokenForSSOResponse|\StructType\GenerateRepLoginUrlForSSOMobileTechAppResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
