<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for IssueStatusEnum EnumType
 * @subpackage Enumerations
 */
class IssueStatusEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'InProgress'
     * @return string 'InProgress'
     */
    const VALUE_IN_PROGRESS = 'InProgress';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'InProgressEscalated'
     * @return string 'InProgressEscalated'
     */
    const VALUE_IN_PROGRESS_ESCALATED = 'InProgressEscalated';
    /**
     * Constant for value 'AlarmDotComEscalated'
     * @return string 'AlarmDotComEscalated'
     */
    const VALUE_ALARM_DOT_COM_ESCALATED = 'AlarmDotComEscalated';
    /**
     * Constant for value 'EscalatedToAlarmDotCom'
     * @return string 'EscalatedToAlarmDotCom'
     */
    const VALUE_ESCALATED_TO_ALARM_DOT_COM = 'EscalatedToAlarmDotCom';
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_IN_PROGRESS_ESCALATED
     * @uses self::VALUE_ALARM_DOT_COM_ESCALATED
     * @uses self::VALUE_ESCALATED_TO_ALARM_DOT_COM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_IN_PROGRESS,
            self::VALUE_CLOSED,
            self::VALUE_IN_PROGRESS_ESCALATED,
            self::VALUE_ALARM_DOT_COM_ESCALATED,
            self::VALUE_ESCALATED_TO_ALARM_DOT_COM,
        );
    }
}
