<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRepRole ArrayType
 * @subpackage Arrays
 */
class ArrayOfRepRole extends AbstractStructArrayBase
{
    /**
     * The RepRole
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RepRole[]
     */
    public $RepRole;
    /**
     * Constructor method for ArrayOfRepRole
     * @uses ArrayOfRepRole::setRepRole()
     * @param \StructType\RepRole[] $repRole
     */
    public function __construct(array $repRole = array())
    {
        $this
            ->setRepRole($repRole);
    }
    /**
     * Get RepRole value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RepRole[]|null
     */
    public function getRepRole()
    {
        return isset($this->RepRole) ? $this->RepRole : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRepRole method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRepRole method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRepRoleForArrayConstraintsFromSetRepRole(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRepRoleRepRoleItem) {
            // validation for constraint: itemType
            if (!$arrayOfRepRoleRepRoleItem instanceof \StructType\RepRole) {
                $invalidValues[] = is_object($arrayOfRepRoleRepRoleItem) ? get_class($arrayOfRepRoleRepRoleItem) : sprintf('%s(%s)', gettype($arrayOfRepRoleRepRoleItem), var_export($arrayOfRepRoleRepRoleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RepRole property can only contain items of type \StructType\RepRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RepRole value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RepRole[] $repRole
     * @return \ArrayType\ArrayOfRepRole
     */
    public function setRepRole(array $repRole = array())
    {
        // validation for constraint: array
        if ('' !== ($repRoleArrayErrorMessage = self::validateRepRoleForArrayConstraintsFromSetRepRole($repRole))) {
            throw new \InvalidArgumentException($repRoleArrayErrorMessage, __LINE__);
        }
        if (is_null($repRole) || (is_array($repRole) && empty($repRole))) {
            unset($this->RepRole);
        } else {
            $this->RepRole = $repRole;
        }
        return $this;
    }
    /**
     * Add item to RepRole value
     * @throws \InvalidArgumentException
     * @param \StructType\RepRole $item
     * @return \ArrayType\ArrayOfRepRole
     */
    public function addToRepRole(\StructType\RepRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RepRole) {
            throw new \InvalidArgumentException(sprintf('The RepRole property can only contain items of type \StructType\RepRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RepRole[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RepRole|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RepRole|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RepRole|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RepRole|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RepRole|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RepRole
     */
    public function getAttributeName()
    {
        return 'RepRole';
    }
}
