<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPackageTemplate ArrayType
 * @subpackage Arrays
 */
class ArrayOfPackageTemplate extends AbstractStructArrayBase
{
    /**
     * The PackageTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PackageTemplate[]
     */
    public $PackageTemplate;
    /**
     * Constructor method for ArrayOfPackageTemplate
     * @uses ArrayOfPackageTemplate::setPackageTemplate()
     * @param \StructType\PackageTemplate[] $packageTemplate
     */
    public function __construct(array $packageTemplate = array())
    {
        $this
            ->setPackageTemplate($packageTemplate);
    }
    /**
     * Get PackageTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PackageTemplate[]|null
     */
    public function getPackageTemplate()
    {
        return isset($this->PackageTemplate) ? $this->PackageTemplate : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageTemplate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageTemplate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageTemplateForArrayConstraintsFromSetPackageTemplate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPackageTemplatePackageTemplateItem) {
            // validation for constraint: itemType
            if (!$arrayOfPackageTemplatePackageTemplateItem instanceof \StructType\PackageTemplate) {
                $invalidValues[] = is_object($arrayOfPackageTemplatePackageTemplateItem) ? get_class($arrayOfPackageTemplatePackageTemplateItem) : sprintf('%s(%s)', gettype($arrayOfPackageTemplatePackageTemplateItem), var_export($arrayOfPackageTemplatePackageTemplateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageTemplate property can only contain items of type \StructType\PackageTemplate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackageTemplate[] $packageTemplate
     * @return \ArrayType\ArrayOfPackageTemplate
     */
    public function setPackageTemplate(array $packageTemplate = array())
    {
        // validation for constraint: array
        if ('' !== ($packageTemplateArrayErrorMessage = self::validatePackageTemplateForArrayConstraintsFromSetPackageTemplate($packageTemplate))) {
            throw new \InvalidArgumentException($packageTemplateArrayErrorMessage, __LINE__);
        }
        if (is_null($packageTemplate) || (is_array($packageTemplate) && empty($packageTemplate))) {
            unset($this->PackageTemplate);
        } else {
            $this->PackageTemplate = $packageTemplate;
        }
        return $this;
    }
    /**
     * Add item to PackageTemplate value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageTemplate $item
     * @return \ArrayType\ArrayOfPackageTemplate
     */
    public function addToPackageTemplate(\StructType\PackageTemplate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageTemplate) {
            throw new \InvalidArgumentException(sprintf('The PackageTemplate property can only contain items of type \StructType\PackageTemplate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageTemplate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PackageTemplate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PackageTemplate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PackageTemplate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PackageTemplate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PackageTemplate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PackageTemplate
     */
    public function getAttributeName()
    {
        return 'PackageTemplate';
    }
}
