<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alarmadmin.alarm.com/WebServices/DealerManagement.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alarmadmin.alarm.com/WebServices/DealerManagement.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for GetWizardWebResponse operation/method
 */
if ($get->GetWizardWebResponse(new \StructType\GetWizardWebResponse()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRepList operation/method
 */
if ($get->GetRepList(new \StructType\GetRepList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRepListForDealer operation/method
 */
if ($get->GetRepListForDealer(new \StructType\GetRepListForDealer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPanelTemplateIds operation/method
 */
if ($get->GetPanelTemplateIds(new \StructType\GetPanelTemplateIds()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPackageIds operation/method
 */
if ($get->GetPackageIds(new \StructType\GetPackageIds()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomPackageTemplates operation/method
 */
if ($get->GetCustomPackageTemplates(new \StructType\GetCustomPackageTemplates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomPackageTemplatesV2 operation/method
 */
if ($get->GetCustomPackageTemplatesV2(new \StructType\GetCustomPackageTemplatesV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRepRoles operation/method
 */
if ($get->GetRepRoles(new \StructType\GetRepRoles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCurrentRepInfo operation/method
 */
if ($get->GetCurrentRepInfo(new \StructType\GetCurrentRepInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDealerId operation/method
 */
if ($get->GetDealerId(new \StructType\GetDealerId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranch operation/method
 */
if ($get->GetBranch(new \StructType\GetBranch()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBranches operation/method
 */
if ($get->GetBranches(new \StructType\GetBranches()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportedPanelTypes operation/method
 */
if ($get->GetSupportedPanelTypes(new \StructType\GetSupportedPanelTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPanelVersionMappings operation/method
 */
if ($get->GetPanelVersionMappings(new \StructType\GetPanelVersionMappings()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRepIdByEmployeeId operation/method
 */
if ($get->GetRepIdByEmployeeId(new \StructType\GetRepIdByEmployeeId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerUnsubscribes operation/method
 */
if ($get->GetCustomerUnsubscribes(new \StructType\GetCustomerUnsubscribes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerUnsubscribesForDealer operation/method
 */
if ($get->GetCustomerUnsubscribesForDealer(new \StructType\GetCustomerUnsubscribesForDealer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBuilderPrograms operation/method
 */
if ($get->GetBuilderPrograms(new \StructType\GetBuilderPrograms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBinderContents operation/method
 */
if ($get->GetBinderContents(new \StructType\GetBinderContents()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTickets operation/method
 */
if ($get->GetSupportTickets(new \StructType\GetSupportTickets()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTicketCategories operation/method
 */
if ($get->GetSupportTicketCategories(new \StructType\GetSupportTicketCategories()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSupportTicketComments operation/method
 */
if ($get->GetSupportTicketComments(new \StructType\GetSupportTicketComments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCSPhoneNumber operation/method
 */
if ($get->GetCSPhoneNumber(new \StructType\GetCSPhoneNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedDealerFileUploadsForDealer operation/method
 */
if ($get->GetExtendedDealerFileUploadsForDealer(new \StructType\GetExtendedDealerFileUploadsForDealer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedDealerFileUpload operation/method
 */
if ($get->GetExtendedDealerFileUpload(new \StructType\GetExtendedDealerFileUpload()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedDealerErrorFile operation/method
 */
if ($get->GetExtendedDealerErrorFile(new \StructType\GetExtendedDealerErrorFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Terminate ServiceType
 */
$terminate = new \ServiceType\Terminate($options);
$terminate->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for TerminateRep operation/method
 */
if ($terminate->TerminateRep(new \StructType\TerminateRep()) !== false) {
    print_r($terminate->getResult());
} else {
    print_r($terminate->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for CreateRepLogin operation/method
 */
if ($create->CreateRepLogin(new \StructType\CreateRepLogin()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateBranch operation/method
 */
if ($create->CreateBranch(new \StructType\CreateBranch()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSeamlessLoginTokenForRep operation/method
 */
if ($create->CreateSeamlessLoginTokenForRep(new \StructType\CreateSeamlessLoginTokenForRep()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSupportTicket operation/method
 */
if ($create->CreateSupportTicket(new \StructType\CreateSupportTicket()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSupportTicketForDealer operation/method
 */
if ($create->CreateSupportTicketForDealer(new \StructType\CreateSupportTicketForDealer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Duplicate ServiceType
 */
$duplicate = new \ServiceType\Duplicate($options);
$duplicate->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for DuplicateBranch operation/method
 */
if ($duplicate->DuplicateBranch(new \StructType\DuplicateBranch()) !== false) {
    print_r($duplicate->getResult());
} else {
    print_r($duplicate->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for UpdateRepLogin operation/method
 */
if ($update->UpdateRepLogin(new \StructType\UpdateRepLogin()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSupportTicket operation/method
 */
if ($update->UpdateSupportTicket(new \StructType\UpdateSupportTicket()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSupportTicketForDealer operation/method
 */
if ($update->UpdateSupportTicketForDealer(new \StructType\UpdateSupportTicketForDealer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
$reset->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for ResetRepPassword operation/method
 */
if ($reset->ResetRepPassword(new \StructType\ResetRepPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for SetIpMaskRestriction operation/method
 */
if ($set->SetIpMaskRestriction(new \StructType\SetIpMaskRestriction()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for CheckAvailableLoginName operation/method
 */
if ($check->CheckAvailableLoginName(new \StructType\CheckAvailableLoginName()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
$generate->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for GenerateRepLoginTokenForSSO operation/method
 */
if ($generate->GenerateRepLoginTokenForSSO(new \StructType\GenerateRepLoginTokenForSSO()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateRepLoginUrlForSSOMobileTechApp operation/method
 */
if ($generate->GenerateRepLoginUrlForSSOMobileTechApp(new \StructType\GenerateRepLoginUrlForSSOMobileTechApp()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Grant ServiceType
 */
$grant = new \ServiceType\Grant($options);
$grant->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for GrantTemporaryAccessForRep operation/method
 */
if ($grant->GrantTemporaryAccessForRep(new \StructType\GrantTemporaryAccessForRep()) !== false) {
    print_r($grant->getResult());
} else {
    print_r($grant->getLastError());
}
/**
 * Samples for Revoke ServiceType
 */
$revoke = new \ServiceType\Revoke($options);
$revoke->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for RevokeTemporaryAccessForRep operation/method
 */
if ($revoke->RevokeTemporaryAccessForRep(new \StructType\RevokeTemporaryAccessForRep()) !== false) {
    print_r($revoke->getResult());
} else {
    print_r($revoke->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for AddToBinder operation/method
 */
if ($add->AddToBinder(new \StructType\AddToBinder()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
$assign->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for AssignTrainingPathToRep operation/method
 */
if ($assign->AssignTrainingPathToRep(new \StructType\AssignTrainingPathToRep()) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for DeleteExtendedDealerFile operation/method
 */
if ($delete->DeleteExtendedDealerFile(new \StructType\DeleteExtendedDealerFile()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
