<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsSupportTicket StructType
 * @subpackage Structs
 */
class WsSupportTicket extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueId;
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerId;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Priority;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Category;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Origin;
    /**
     * The SubmittedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SubmittedDate;
    /**
     * The LastActionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastActionDate;
    /**
     * The Course
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Course;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The IssueDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDescription;
    /**
     * Constructor method for WsSupportTicket
     * @uses WsSupportTicket::setIssueId()
     * @uses WsSupportTicket::setDealerId()
     * @uses WsSupportTicket::setPriority()
     * @uses WsSupportTicket::setStatus()
     * @uses WsSupportTicket::setCustomerID()
     * @uses WsSupportTicket::setCategory()
     * @uses WsSupportTicket::setOrigin()
     * @uses WsSupportTicket::setSubmittedDate()
     * @uses WsSupportTicket::setLastActionDate()
     * @uses WsSupportTicket::setCourse()
     * @uses WsSupportTicket::setReason()
     * @uses WsSupportTicket::setIssueDescription()
     * @param int $issueId
     * @param int $dealerId
     * @param string $priority
     * @param string $status
     * @param int $customerID
     * @param string $category
     * @param string $origin
     * @param string $submittedDate
     * @param string $lastActionDate
     * @param float $course
     * @param string $reason
     * @param string $issueDescription
     */
    public function __construct($issueId = null, $dealerId = null, $priority = null, $status = null, $customerID = null, $category = null, $origin = null, $submittedDate = null, $lastActionDate = null, $course = null, $reason = null, $issueDescription = null)
    {
        $this
            ->setIssueId($issueId)
            ->setDealerId($dealerId)
            ->setPriority($priority)
            ->setStatus($status)
            ->setCustomerID($customerID)
            ->setCategory($category)
            ->setOrigin($origin)
            ->setSubmittedDate($submittedDate)
            ->setLastActionDate($lastActionDate)
            ->setCourse($course)
            ->setReason($reason)
            ->setIssueDescription($issueDescription);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\WsSupportTicket
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \StructType\WsSupportTicket
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get Priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @uses \EnumType\IssuePriorityEnum::valueIsValid()
     * @uses \EnumType\IssuePriorityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\WsSupportTicket
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssuePriorityEnum::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssuePriorityEnum', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \EnumType\IssuePriorityEnum::getValidValues())), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\IssueStatusEnum::valueIsValid()
     * @uses \EnumType\IssueStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\WsSupportTicket
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\IssueStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\WsSupportTicket
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get Category value
     * @return string
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @uses \EnumType\IssueCategoryEnum::valueIsValid()
     * @uses \EnumType\IssueCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \StructType\WsSupportTicket
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueCategoryEnum::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueCategoryEnum', is_array($category) ? implode(', ', $category) : var_export($category, true), implode(', ', \EnumType\IssueCategoryEnum::getValidValues())), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Origin value
     * @return string
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @uses \EnumType\IssueOriginEnum::valueIsValid()
     * @uses \EnumType\IssueOriginEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origin
     * @return \StructType\WsSupportTicket
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueOriginEnum::valueIsValid($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueOriginEnum', is_array($origin) ? implode(', ', $origin) : var_export($origin, true), implode(', ', \EnumType\IssueOriginEnum::getValidValues())), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get SubmittedDate value
     * @return string
     */
    public function getSubmittedDate()
    {
        return $this->SubmittedDate;
    }
    /**
     * Set SubmittedDate value
     * @param string $submittedDate
     * @return \StructType\WsSupportTicket
     */
    public function setSubmittedDate($submittedDate = null)
    {
        // validation for constraint: string
        if (!is_null($submittedDate) && !is_string($submittedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedDate, true), gettype($submittedDate)), __LINE__);
        }
        $this->SubmittedDate = $submittedDate;
        return $this;
    }
    /**
     * Get LastActionDate value
     * @return string
     */
    public function getLastActionDate()
    {
        return $this->LastActionDate;
    }
    /**
     * Set LastActionDate value
     * @param string $lastActionDate
     * @return \StructType\WsSupportTicket
     */
    public function setLastActionDate($lastActionDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionDate) && !is_string($lastActionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActionDate, true), gettype($lastActionDate)), __LINE__);
        }
        $this->LastActionDate = $lastActionDate;
        return $this;
    }
    /**
     * Get Course value
     * @return float
     */
    public function getCourse()
    {
        return $this->Course;
    }
    /**
     * Set Course value
     * @param float $course
     * @return \StructType\WsSupportTicket
     */
    public function setCourse($course = null)
    {
        // validation for constraint: float
        if (!is_null($course) && !(is_float($course) || is_numeric($course))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($course, true), gettype($course)), __LINE__);
        }
        $this->Course = $course;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\WsSupportTicket
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get IssueDescription value
     * @return string|null
     */
    public function getIssueDescription()
    {
        return $this->IssueDescription;
    }
    /**
     * Set IssueDescription value
     * @param string $issueDescription
     * @return \StructType\WsSupportTicket
     */
    public function setIssueDescription($issueDescription = null)
    {
        // validation for constraint: string
        if (!is_null($issueDescription) && !is_string($issueDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDescription, true), gettype($issueDescription)), __LINE__);
        }
        $this->IssueDescription = $issueDescription;
        return $this;
    }
}
