<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsIssueComment StructType
 * @subpackage Structs
 */
class WsIssueComment extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueId;
    /**
     * The Coarse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Coarse;
    /**
     * The CommentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CommentDate;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Author
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Author;
    /**
     * Constructor method for WsIssueComment
     * @uses WsIssueComment::setIssueId()
     * @uses WsIssueComment::setCoarse()
     * @uses WsIssueComment::setCommentDate()
     * @uses WsIssueComment::setComment()
     * @uses WsIssueComment::setAuthor()
     * @param int $issueId
     * @param float $coarse
     * @param string $commentDate
     * @param string $comment
     * @param string $author
     */
    public function __construct($issueId = null, $coarse = null, $commentDate = null, $comment = null, $author = null)
    {
        $this
            ->setIssueId($issueId)
            ->setCoarse($coarse)
            ->setCommentDate($commentDate)
            ->setComment($comment)
            ->setAuthor($author);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\WsIssueComment
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get Coarse value
     * @return float
     */
    public function getCoarse()
    {
        return $this->Coarse;
    }
    /**
     * Set Coarse value
     * @param float $coarse
     * @return \StructType\WsIssueComment
     */
    public function setCoarse($coarse = null)
    {
        // validation for constraint: float
        if (!is_null($coarse) && !(is_float($coarse) || is_numeric($coarse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($coarse, true), gettype($coarse)), __LINE__);
        }
        $this->Coarse = $coarse;
        return $this;
    }
    /**
     * Get CommentDate value
     * @return string
     */
    public function getCommentDate()
    {
        return $this->CommentDate;
    }
    /**
     * Set CommentDate value
     * @param string $commentDate
     * @return \StructType\WsIssueComment
     */
    public function setCommentDate($commentDate = null)
    {
        // validation for constraint: string
        if (!is_null($commentDate) && !is_string($commentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentDate, true), gettype($commentDate)), __LINE__);
        }
        $this->CommentDate = $commentDate;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\WsIssueComment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Author value
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->Author;
    }
    /**
     * Set Author value
     * @param string $author
     * @return \StructType\WsIssueComment
     */
    public function setAuthor($author = null)
    {
        // validation for constraint: string
        if (!is_null($author) && !is_string($author)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($author, true), gettype($author)), __LINE__);
        }
        $this->Author = $author;
        return $this;
    }
}
