<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSupportTicketInput StructType
 * @subpackage Structs
 */
class UpdateSupportTicketInput extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueId;
    /**
     * The NewStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $NewStatus;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The ShowCommentToCustomerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowCommentToCustomerAndSendEmail;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for UpdateSupportTicketInput
     * @uses UpdateSupportTicketInput::setIssueId()
     * @uses UpdateSupportTicketInput::setNewStatus()
     * @uses UpdateSupportTicketInput::setCustomerId()
     * @uses UpdateSupportTicketInput::setShowCommentToCustomerAndSendEmail()
     * @uses UpdateSupportTicketInput::setComment()
     * @param int $issueId
     * @param string $newStatus
     * @param int $customerId
     * @param bool $showCommentToCustomerAndSendEmail
     * @param string $comment
     */
    public function __construct($issueId = null, $newStatus = null, $customerId = null, $showCommentToCustomerAndSendEmail = null, $comment = null)
    {
        $this
            ->setIssueId($issueId)
            ->setNewStatus($newStatus)
            ->setCustomerId($customerId)
            ->setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail)
            ->setComment($comment);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\UpdateSupportTicketInput
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get NewStatus value
     * @return string
     */
    public function getNewStatus()
    {
        return $this->NewStatus;
    }
    /**
     * Set NewStatus value
     * @uses \EnumType\IssueStatusEnum::valueIsValid()
     * @uses \EnumType\IssueStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \StructType\UpdateSupportTicketInput
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueStatusEnum::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueStatusEnum', is_array($newStatus) ? implode(', ', $newStatus) : var_export($newStatus, true), implode(', ', \EnumType\IssueStatusEnum::getValidValues())), __LINE__);
        }
        $this->NewStatus = $newStatus;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\UpdateSupportTicketInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ShowCommentToCustomerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToCustomerAndSendEmail()
    {
        return $this->ShowCommentToCustomerAndSendEmail;
    }
    /**
     * Set ShowCommentToCustomerAndSendEmail value
     * @param bool $showCommentToCustomerAndSendEmail
     * @return \StructType\UpdateSupportTicketInput
     */
    public function setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToCustomerAndSendEmail) && !is_bool($showCommentToCustomerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToCustomerAndSendEmail, true), gettype($showCommentToCustomerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToCustomerAndSendEmail = $showCommentToCustomerAndSendEmail;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\UpdateSupportTicketInput
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
