<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RepRole StructType
 * @subpackage Structs
 */
class RepRole extends AbstractStructBase
{
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoleId;
    /**
     * The RoleTypeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoleTypeId;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * The RoleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleDescription;
    /**
     * Constructor method for RepRole
     * @uses RepRole::setRoleId()
     * @uses RepRole::setRoleTypeId()
     * @uses RepRole::setRoleName()
     * @uses RepRole::setRoleDescription()
     * @param int $roleId
     * @param string $roleTypeId
     * @param string $roleName
     * @param string $roleDescription
     */
    public function __construct($roleId = null, $roleTypeId = null, $roleName = null, $roleDescription = null)
    {
        $this
            ->setRoleId($roleId)
            ->setRoleTypeId($roleTypeId)
            ->setRoleName($roleName)
            ->setRoleDescription($roleDescription);
    }
    /**
     * Get RoleId value
     * @return int
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param int $roleId
     * @return \StructType\RepRole
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: int
        if (!is_null($roleId) && !(is_int($roleId) || ctype_digit($roleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Get RoleTypeId value
     * @return string
     */
    public function getRoleTypeId()
    {
        return $this->RoleTypeId;
    }
    /**
     * Set RoleTypeId value
     * @uses \EnumType\CustomerRepRoleTypeEnum::valueIsValid()
     * @uses \EnumType\CustomerRepRoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleTypeId
     * @return \StructType\RepRole
     */
    public function setRoleTypeId($roleTypeId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerRepRoleTypeEnum::valueIsValid($roleTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerRepRoleTypeEnum', is_array($roleTypeId) ? implode(', ', $roleTypeId) : var_export($roleTypeId, true), implode(', ', \EnumType\CustomerRepRoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->RoleTypeId = $roleTypeId;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \StructType\RepRole
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleName, true), gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
    /**
     * Get RoleDescription value
     * @return string|null
     */
    public function getRoleDescription()
    {
        return $this->RoleDescription;
    }
    /**
     * Set RoleDescription value
     * @param string $roleDescription
     * @return \StructType\RepRole
     */
    public function setRoleDescription($roleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($roleDescription) && !is_string($roleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleDescription, true), gettype($roleDescription)), __LINE__);
        }
        $this->RoleDescription = $roleDescription;
        return $this;
    }
}
