<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageInfo StructType
 * @subpackage Structs
 */
class PackageInfo extends AbstractStructBase
{
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageId;
    /**
     * The AddonsFilteredDueToCallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddonsFilteredDueToCallerVersion;
    /**
     * The PackageDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageDescription;
    /**
     * The PackageGroupDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageGroupDescription;
    /**
     * The IncludedFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddOnFeatureInfo
     */
    public $IncludedFeatures;
    /**
     * The FreeAddOns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddOnFeatureInfo
     */
    public $FreeAddOns;
    /**
     * The OtherAddOns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddOnFeatureInfo
     */
    public $OtherAddOns;
    /**
     * Constructor method for PackageInfo
     * @uses PackageInfo::setPackageId()
     * @uses PackageInfo::setAddonsFilteredDueToCallerVersion()
     * @uses PackageInfo::setPackageDescription()
     * @uses PackageInfo::setPackageGroupDescription()
     * @uses PackageInfo::setIncludedFeatures()
     * @uses PackageInfo::setFreeAddOns()
     * @uses PackageInfo::setOtherAddOns()
     * @param int $packageId
     * @param bool $addonsFilteredDueToCallerVersion
     * @param string $packageDescription
     * @param string $packageGroupDescription
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $includedFeatures
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $freeAddOns
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $otherAddOns
     */
    public function __construct($packageId = null, $addonsFilteredDueToCallerVersion = null, $packageDescription = null, $packageGroupDescription = null, \ArrayType\ArrayOfAddOnFeatureInfo $includedFeatures = null, \ArrayType\ArrayOfAddOnFeatureInfo $freeAddOns = null, \ArrayType\ArrayOfAddOnFeatureInfo $otherAddOns = null)
    {
        $this
            ->setPackageId($packageId)
            ->setAddonsFilteredDueToCallerVersion($addonsFilteredDueToCallerVersion)
            ->setPackageDescription($packageDescription)
            ->setPackageGroupDescription($packageGroupDescription)
            ->setIncludedFeatures($includedFeatures)
            ->setFreeAddOns($freeAddOns)
            ->setOtherAddOns($otherAddOns);
    }
    /**
     * Get PackageId value
     * @return int
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \StructType\PackageInfo
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get AddonsFilteredDueToCallerVersion value
     * @return bool
     */
    public function getAddonsFilteredDueToCallerVersion()
    {
        return $this->AddonsFilteredDueToCallerVersion;
    }
    /**
     * Set AddonsFilteredDueToCallerVersion value
     * @param bool $addonsFilteredDueToCallerVersion
     * @return \StructType\PackageInfo
     */
    public function setAddonsFilteredDueToCallerVersion($addonsFilteredDueToCallerVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($addonsFilteredDueToCallerVersion) && !is_bool($addonsFilteredDueToCallerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addonsFilteredDueToCallerVersion, true), gettype($addonsFilteredDueToCallerVersion)), __LINE__);
        }
        $this->AddonsFilteredDueToCallerVersion = $addonsFilteredDueToCallerVersion;
        return $this;
    }
    /**
     * Get PackageDescription value
     * @return string|null
     */
    public function getPackageDescription()
    {
        return $this->PackageDescription;
    }
    /**
     * Set PackageDescription value
     * @param string $packageDescription
     * @return \StructType\PackageInfo
     */
    public function setPackageDescription($packageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageDescription) && !is_string($packageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageDescription, true), gettype($packageDescription)), __LINE__);
        }
        $this->PackageDescription = $packageDescription;
        return $this;
    }
    /**
     * Get PackageGroupDescription value
     * @return string|null
     */
    public function getPackageGroupDescription()
    {
        return $this->PackageGroupDescription;
    }
    /**
     * Set PackageGroupDescription value
     * @param string $packageGroupDescription
     * @return \StructType\PackageInfo
     */
    public function setPackageGroupDescription($packageGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageGroupDescription) && !is_string($packageGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageGroupDescription, true), gettype($packageGroupDescription)), __LINE__);
        }
        $this->PackageGroupDescription = $packageGroupDescription;
        return $this;
    }
    /**
     * Get IncludedFeatures value
     * @return \ArrayType\ArrayOfAddOnFeatureInfo|null
     */
    public function getIncludedFeatures()
    {
        return $this->IncludedFeatures;
    }
    /**
     * Set IncludedFeatures value
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $includedFeatures
     * @return \StructType\PackageInfo
     */
    public function setIncludedFeatures(\ArrayType\ArrayOfAddOnFeatureInfo $includedFeatures = null)
    {
        $this->IncludedFeatures = $includedFeatures;
        return $this;
    }
    /**
     * Get FreeAddOns value
     * @return \ArrayType\ArrayOfAddOnFeatureInfo|null
     */
    public function getFreeAddOns()
    {
        return $this->FreeAddOns;
    }
    /**
     * Set FreeAddOns value
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $freeAddOns
     * @return \StructType\PackageInfo
     */
    public function setFreeAddOns(\ArrayType\ArrayOfAddOnFeatureInfo $freeAddOns = null)
    {
        $this->FreeAddOns = $freeAddOns;
        return $this;
    }
    /**
     * Get OtherAddOns value
     * @return \ArrayType\ArrayOfAddOnFeatureInfo|null
     */
    public function getOtherAddOns()
    {
        return $this->OtherAddOns;
    }
    /**
     * Set OtherAddOns value
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $otherAddOns
     * @return \StructType\PackageInfo
     */
    public function setOtherAddOns(\ArrayType\ArrayOfAddOnFeatureInfo $otherAddOns = null)
    {
        $this->OtherAddOns = $otherAddOns;
        return $this;
    }
}
