<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GrantTemporaryAccessForRepInput StructType
 * @subpackage Structs
 */
class GrantTemporaryAccessForRepInput extends AbstractStructBase
{
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * Constructor method for GrantTemporaryAccessForRepInput
     * @uses GrantTemporaryAccessForRepInput::setRepId()
     * @uses GrantTemporaryAccessForRepInput::setCustomerId()
     * @param int $repId
     * @param int $customerId
     */
    public function __construct($repId = null, $customerId = null)
    {
        $this
            ->setRepId($repId)
            ->setCustomerId($customerId);
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\GrantTemporaryAccessForRepInput
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\GrantTemporaryAccessForRepInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
