<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerUnsubscribesInput StructType
 * @subpackage Structs
 */
class GetCustomerUnsubscribesInput extends AbstractStructBase
{
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DealerId;
    /**
     * The DealerBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerBranchId;
    /**
     * Constructor method for GetCustomerUnsubscribesInput
     * @uses GetCustomerUnsubscribesInput::setDealerId()
     * @uses GetCustomerUnsubscribesInput::setDealerBranchId()
     * @param int $dealerId
     * @param int $dealerBranchId
     */
    public function __construct($dealerId = null, $dealerBranchId = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setDealerBranchId($dealerBranchId);
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \StructType\GetCustomerUnsubscribesInput
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get DealerBranchId value
     * @return int
     */
    public function getDealerBranchId()
    {
        return $this->DealerBranchId;
    }
    /**
     * Set DealerBranchId value
     * @param int $dealerBranchId
     * @return \StructType\GetCustomerUnsubscribesInput
     */
    public function setDealerBranchId($dealerBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerBranchId) && !(is_int($dealerBranchId) || ctype_digit($dealerBranchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerBranchId, true), gettype($dealerBranchId)), __LINE__);
        }
        $this->DealerBranchId = $dealerBranchId;
        return $this;
    }
}
