<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomPackageTemplatesV2Input StructType
 * @subpackage Structs
 */
class GetCustomPackageTemplatesV2Input extends AbstractStructBase
{
    /**
     * The CallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * Constructor method for GetCustomPackageTemplatesV2Input
     * @uses GetCustomPackageTemplatesV2Input::setCallerVersion()
     * @uses GetCustomPackageTemplatesV2Input::setBranchId()
     * @param int $callerVersion
     * @param int $branchId
     */
    public function __construct($callerVersion = null, $branchId = null)
    {
        $this
            ->setCallerVersion($callerVersion)
            ->setBranchId($branchId);
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \StructType\GetCustomPackageTemplatesV2Input
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !(is_int($callerVersion) || ctype_digit($callerVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callerVersion, true), gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \StructType\GetCustomPackageTemplatesV2Input
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
}
