<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomPackageTemplatesOutput StructType
 * @subpackage Structs
 */
class GetCustomPackageTemplatesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The PackageTemplates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPackageTemplate
     */
    public $PackageTemplates;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetCustomPackageTemplatesOutput
     * @uses GetCustomPackageTemplatesOutput::setSuccess()
     * @uses GetCustomPackageTemplatesOutput::setPackageTemplates()
     * @uses GetCustomPackageTemplatesOutput::setErrorMessage()
     * @param bool $success
     * @param \ArrayType\ArrayOfPackageTemplate $packageTemplates
     * @param string $errorMessage
     */
    public function __construct($success = null, \ArrayType\ArrayOfPackageTemplate $packageTemplates = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setPackageTemplates($packageTemplates)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetCustomPackageTemplatesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get PackageTemplates value
     * @return \ArrayType\ArrayOfPackageTemplate|null
     */
    public function getPackageTemplates()
    {
        return $this->PackageTemplates;
    }
    /**
     * Set PackageTemplates value
     * @param \ArrayType\ArrayOfPackageTemplate $packageTemplates
     * @return \StructType\GetCustomPackageTemplatesOutput
     */
    public function setPackageTemplates(\ArrayType\ArrayOfPackageTemplate $packageTemplates = null)
    {
        $this->PackageTemplates = $packageTemplates;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetCustomPackageTemplatesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
