<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DuplicateBranchInput StructType
 * @subpackage Structs
 */
class DuplicateBranchInput extends AbstractStructBase
{
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchId;
    /**
     * The DuplicateBranchName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DuplicateBranchName;
    /**
     * Constructor method for DuplicateBranchInput
     * @uses DuplicateBranchInput::setBranchId()
     * @uses DuplicateBranchInput::setDuplicateBranchName()
     * @param int $branchId
     * @param string $duplicateBranchName
     */
    public function __construct($branchId = null, $duplicateBranchName = null)
    {
        $this
            ->setBranchId($branchId)
            ->setDuplicateBranchName($duplicateBranchName);
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \StructType\DuplicateBranchInput
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get DuplicateBranchName value
     * @return string|null
     */
    public function getDuplicateBranchName()
    {
        return $this->DuplicateBranchName;
    }
    /**
     * Set DuplicateBranchName value
     * @param string $duplicateBranchName
     * @return \StructType\DuplicateBranchInput
     */
    public function setDuplicateBranchName($duplicateBranchName = null)
    {
        // validation for constraint: string
        if (!is_null($duplicateBranchName) && !is_string($duplicateBranchName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duplicateBranchName, true), gettype($duplicateBranchName)), __LINE__);
        }
        $this->DuplicateBranchName = $duplicateBranchName;
        return $this;
    }
}
