<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSupportTicketOutput StructType
 * @subpackage Structs
 */
class CreateSupportTicketOutput extends AbstractStructBase
{
    /**
     * The IssueId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IssueId;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for CreateSupportTicketOutput
     * @uses CreateSupportTicketOutput::setIssueId()
     * @uses CreateSupportTicketOutput::setSuccess()
     * @uses CreateSupportTicketOutput::setErrorMessage()
     * @param int $issueId
     * @param bool $success
     * @param string $errorMessage
     */
    public function __construct($issueId = null, $success = null, $errorMessage = null)
    {
        $this
            ->setIssueId($issueId)
            ->setSuccess($success)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get IssueId value
     * @return int
     */
    public function getIssueId()
    {
        return $this->IssueId;
    }
    /**
     * Set IssueId value
     * @param int $issueId
     * @return \StructType\CreateSupportTicketOutput
     */
    public function setIssueId($issueId = null)
    {
        // validation for constraint: int
        if (!is_null($issueId) && !(is_int($issueId) || ctype_digit($issueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueId, true), gettype($issueId)), __LINE__);
        }
        $this->IssueId = $issueId;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\CreateSupportTicketOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\CreateSupportTicketOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
