<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSupportTicketInput StructType
 * @subpackage Structs
 */
class CreateSupportTicketInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The IssueCategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueCategoryId;
    /**
     * The ShowCommentToCustomerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowCommentToCustomerAndSendEmail;
    /**
     * The IssueDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDescription;
    /**
     * Constructor method for CreateSupportTicketInput
     * @uses CreateSupportTicketInput::setCustomerId()
     * @uses CreateSupportTicketInput::setIssueCategoryId()
     * @uses CreateSupportTicketInput::setShowCommentToCustomerAndSendEmail()
     * @uses CreateSupportTicketInput::setIssueDescription()
     * @param int $customerId
     * @param int $issueCategoryId
     * @param bool $showCommentToCustomerAndSendEmail
     * @param string $issueDescription
     */
    public function __construct($customerId = null, $issueCategoryId = null, $showCommentToCustomerAndSendEmail = null, $issueDescription = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setIssueCategoryId($issueCategoryId)
            ->setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail)
            ->setIssueDescription($issueDescription);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CreateSupportTicketInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get IssueCategoryId value
     * @return int
     */
    public function getIssueCategoryId()
    {
        return $this->IssueCategoryId;
    }
    /**
     * Set IssueCategoryId value
     * @param int $issueCategoryId
     * @return \StructType\CreateSupportTicketInput
     */
    public function setIssueCategoryId($issueCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($issueCategoryId) && !(is_int($issueCategoryId) || ctype_digit($issueCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueCategoryId, true), gettype($issueCategoryId)), __LINE__);
        }
        $this->IssueCategoryId = $issueCategoryId;
        return $this;
    }
    /**
     * Get ShowCommentToCustomerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToCustomerAndSendEmail()
    {
        return $this->ShowCommentToCustomerAndSendEmail;
    }
    /**
     * Set ShowCommentToCustomerAndSendEmail value
     * @param bool $showCommentToCustomerAndSendEmail
     * @return \StructType\CreateSupportTicketInput
     */
    public function setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToCustomerAndSendEmail) && !is_bool($showCommentToCustomerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToCustomerAndSendEmail, true), gettype($showCommentToCustomerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToCustomerAndSendEmail = $showCommentToCustomerAndSendEmail;
        return $this;
    }
    /**
     * Get IssueDescription value
     * @return string|null
     */
    public function getIssueDescription()
    {
        return $this->IssueDescription;
    }
    /**
     * Set IssueDescription value
     * @param string $issueDescription
     * @return \StructType\CreateSupportTicketInput
     */
    public function setIssueDescription($issueDescription = null)
    {
        // validation for constraint: string
        if (!is_null($issueDescription) && !is_string($issueDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDescription, true), gettype($issueDescription)), __LINE__);
        }
        $this->IssueDescription = $issueDescription;
        return $this;
    }
}
