<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSupportTicketForDealerInput StructType
 * @subpackage Structs
 */
class CreateSupportTicketForDealerInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DealerId;
    /**
     * The IssueCategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IssueCategoryId;
    /**
     * The ShowCommentToCustomerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowCommentToCustomerAndSendEmail;
    /**
     * The ShowCommentToDealerAndSendEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowCommentToDealerAndSendEmail;
    /**
     * The issueOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issueOrigin;
    /**
     * The issueStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issueStatus;
    /**
     * The issuePriority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issuePriority;
    /**
     * The IsReportedByGenericRep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReportedByGenericRep;
    /**
     * The IsReportedByDealer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReportedByDealer;
    /**
     * The IssueDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDescription;
    /**
     * The IssueOwnerLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueOwnerLoginName;
    /**
     * Constructor method for CreateSupportTicketForDealerInput
     * @uses CreateSupportTicketForDealerInput::setCustomerId()
     * @uses CreateSupportTicketForDealerInput::setDealerId()
     * @uses CreateSupportTicketForDealerInput::setIssueCategoryId()
     * @uses CreateSupportTicketForDealerInput::setShowCommentToCustomerAndSendEmail()
     * @uses CreateSupportTicketForDealerInput::setShowCommentToDealerAndSendEmail()
     * @uses CreateSupportTicketForDealerInput::setIssueOrigin()
     * @uses CreateSupportTicketForDealerInput::setIssueStatus()
     * @uses CreateSupportTicketForDealerInput::setIssuePriority()
     * @uses CreateSupportTicketForDealerInput::setIsReportedByGenericRep()
     * @uses CreateSupportTicketForDealerInput::setIsReportedByDealer()
     * @uses CreateSupportTicketForDealerInput::setIssueDescription()
     * @uses CreateSupportTicketForDealerInput::setIssueOwnerLoginName()
     * @param int $customerId
     * @param int $dealerId
     * @param int $issueCategoryId
     * @param bool $showCommentToCustomerAndSendEmail
     * @param bool $showCommentToDealerAndSendEmail
     * @param string $issueOrigin
     * @param string $issueStatus
     * @param string $issuePriority
     * @param bool $isReportedByGenericRep
     * @param bool $isReportedByDealer
     * @param string $issueDescription
     * @param string $issueOwnerLoginName
     */
    public function __construct($customerId = null, $dealerId = null, $issueCategoryId = null, $showCommentToCustomerAndSendEmail = null, $showCommentToDealerAndSendEmail = null, $issueOrigin = null, $issueStatus = null, $issuePriority = null, $isReportedByGenericRep = null, $isReportedByDealer = null, $issueDescription = null, $issueOwnerLoginName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDealerId($dealerId)
            ->setIssueCategoryId($issueCategoryId)
            ->setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail)
            ->setShowCommentToDealerAndSendEmail($showCommentToDealerAndSendEmail)
            ->setIssueOrigin($issueOrigin)
            ->setIssueStatus($issueStatus)
            ->setIssuePriority($issuePriority)
            ->setIsReportedByGenericRep($isReportedByGenericRep)
            ->setIsReportedByDealer($isReportedByDealer)
            ->setIssueDescription($issueDescription)
            ->setIssueOwnerLoginName($issueOwnerLoginName);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get IssueCategoryId value
     * @return int
     */
    public function getIssueCategoryId()
    {
        return $this->IssueCategoryId;
    }
    /**
     * Set IssueCategoryId value
     * @param int $issueCategoryId
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssueCategoryId($issueCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($issueCategoryId) && !(is_int($issueCategoryId) || ctype_digit($issueCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issueCategoryId, true), gettype($issueCategoryId)), __LINE__);
        }
        $this->IssueCategoryId = $issueCategoryId;
        return $this;
    }
    /**
     * Get ShowCommentToCustomerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToCustomerAndSendEmail()
    {
        return $this->ShowCommentToCustomerAndSendEmail;
    }
    /**
     * Set ShowCommentToCustomerAndSendEmail value
     * @param bool $showCommentToCustomerAndSendEmail
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setShowCommentToCustomerAndSendEmail($showCommentToCustomerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToCustomerAndSendEmail) && !is_bool($showCommentToCustomerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToCustomerAndSendEmail, true), gettype($showCommentToCustomerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToCustomerAndSendEmail = $showCommentToCustomerAndSendEmail;
        return $this;
    }
    /**
     * Get ShowCommentToDealerAndSendEmail value
     * @return bool
     */
    public function getShowCommentToDealerAndSendEmail()
    {
        return $this->ShowCommentToDealerAndSendEmail;
    }
    /**
     * Set ShowCommentToDealerAndSendEmail value
     * @param bool $showCommentToDealerAndSendEmail
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setShowCommentToDealerAndSendEmail($showCommentToDealerAndSendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCommentToDealerAndSendEmail) && !is_bool($showCommentToDealerAndSendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCommentToDealerAndSendEmail, true), gettype($showCommentToDealerAndSendEmail)), __LINE__);
        }
        $this->ShowCommentToDealerAndSendEmail = $showCommentToDealerAndSendEmail;
        return $this;
    }
    /**
     * Get issueOrigin value
     * @return string
     */
    public function getIssueOrigin()
    {
        return $this->issueOrigin;
    }
    /**
     * Set issueOrigin value
     * @uses \EnumType\IssueOriginEnum::valueIsValid()
     * @uses \EnumType\IssueOriginEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $issueOrigin
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssueOrigin($issueOrigin = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueOriginEnum::valueIsValid($issueOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueOriginEnum', is_array($issueOrigin) ? implode(', ', $issueOrigin) : var_export($issueOrigin, true), implode(', ', \EnumType\IssueOriginEnum::getValidValues())), __LINE__);
        }
        $this->issueOrigin = $issueOrigin;
        return $this;
    }
    /**
     * Get issueStatus value
     * @return string
     */
    public function getIssueStatus()
    {
        return $this->issueStatus;
    }
    /**
     * Set issueStatus value
     * @uses \EnumType\IssueStatusEnum::valueIsValid()
     * @uses \EnumType\IssueStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $issueStatus
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssueStatus($issueStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueStatusEnum::valueIsValid($issueStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueStatusEnum', is_array($issueStatus) ? implode(', ', $issueStatus) : var_export($issueStatus, true), implode(', ', \EnumType\IssueStatusEnum::getValidValues())), __LINE__);
        }
        $this->issueStatus = $issueStatus;
        return $this;
    }
    /**
     * Get issuePriority value
     * @return string
     */
    public function getIssuePriority()
    {
        return $this->issuePriority;
    }
    /**
     * Set issuePriority value
     * @uses \EnumType\IssuePriorityEnum::valueIsValid()
     * @uses \EnumType\IssuePriorityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $issuePriority
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssuePriority($issuePriority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssuePriorityEnum::valueIsValid($issuePriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssuePriorityEnum', is_array($issuePriority) ? implode(', ', $issuePriority) : var_export($issuePriority, true), implode(', ', \EnumType\IssuePriorityEnum::getValidValues())), __LINE__);
        }
        $this->issuePriority = $issuePriority;
        return $this;
    }
    /**
     * Get IsReportedByGenericRep value
     * @return bool
     */
    public function getIsReportedByGenericRep()
    {
        return $this->IsReportedByGenericRep;
    }
    /**
     * Set IsReportedByGenericRep value
     * @param bool $isReportedByGenericRep
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIsReportedByGenericRep($isReportedByGenericRep = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReportedByGenericRep) && !is_bool($isReportedByGenericRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReportedByGenericRep, true), gettype($isReportedByGenericRep)), __LINE__);
        }
        $this->IsReportedByGenericRep = $isReportedByGenericRep;
        return $this;
    }
    /**
     * Get IsReportedByDealer value
     * @return bool
     */
    public function getIsReportedByDealer()
    {
        return $this->IsReportedByDealer;
    }
    /**
     * Set IsReportedByDealer value
     * @param bool $isReportedByDealer
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIsReportedByDealer($isReportedByDealer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReportedByDealer) && !is_bool($isReportedByDealer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReportedByDealer, true), gettype($isReportedByDealer)), __LINE__);
        }
        $this->IsReportedByDealer = $isReportedByDealer;
        return $this;
    }
    /**
     * Get IssueDescription value
     * @return string|null
     */
    public function getIssueDescription()
    {
        return $this->IssueDescription;
    }
    /**
     * Set IssueDescription value
     * @param string $issueDescription
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssueDescription($issueDescription = null)
    {
        // validation for constraint: string
        if (!is_null($issueDescription) && !is_string($issueDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDescription, true), gettype($issueDescription)), __LINE__);
        }
        $this->IssueDescription = $issueDescription;
        return $this;
    }
    /**
     * Get IssueOwnerLoginName value
     * @return string|null
     */
    public function getIssueOwnerLoginName()
    {
        return $this->IssueOwnerLoginName;
    }
    /**
     * Set IssueOwnerLoginName value
     * @param string $issueOwnerLoginName
     * @return \StructType\CreateSupportTicketForDealerInput
     */
    public function setIssueOwnerLoginName($issueOwnerLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($issueOwnerLoginName) && !is_string($issueOwnerLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueOwnerLoginName, true), gettype($issueOwnerLoginName)), __LINE__);
        }
        $this->IssueOwnerLoginName = $issueOwnerLoginName;
        return $this;
    }
}
